/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.recipe.type;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.StringUtils;
import com.shanebeestudios.skbee.api.recipe.RecipeType;
import com.shanebeestudios.skbee.api.util.Util;
import com.shanebeestudios.skbee.api.wrapper.EnumWrapper;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.converter.Converter;
import org.skriptlang.skript.lang.converter.Converters;

public class Types {
    private static String recipeChoiceToString(RecipeChoice recipeChoice) {
        ArrayList itemTypes = new ArrayList();
        if (recipeChoice instanceof RecipeChoice.MaterialChoice) {
            RecipeChoice.MaterialChoice materialChoice = (RecipeChoice.MaterialChoice)recipeChoice;
            materialChoice.getChoices().forEach(material -> itemTypes.add(new ItemType(material).toString()));
            return String.format("MaterialChoice{choices=[%s]}", StringUtils.join(itemTypes, (String)", "));
        }
        if (recipeChoice instanceof RecipeChoice.ExactChoice) {
            RecipeChoice.ExactChoice exactChoice = (RecipeChoice.ExactChoice)recipeChoice;
            exactChoice.getChoices().forEach(material -> itemTypes.add(new ItemType(material).toString()));
            return String.format("ExactChoice{choices=[%s]}", StringUtils.join(itemTypes, (String)", "));
        }
        throw new IllegalStateException("This shouldnt happen!!!");
    }

    static {
        if (Classes.getExactClassInfo(RecipeChoice.class) == null) {
            Classes.registerClass((ClassInfo)new ClassInfo(RecipeChoice.class, "recipechoice").name("Recipe Choice").user(new String[]{"recipe ?choices?"}).description(new String[]{"Represents an Exact/Material Choice.", "MaterialChoice represents a set of materials/minecraft tags which can be used in some recipes.", "ExactChoice represents a special ItemStack used in some recipes.", "Requires Minecraft 1.13+"}).usage(new String[]{"see material choice expression"}).examples(new String[]{"set {_a} to material choice of diamond sword, diamond shovel and diamond hoe", "set {_a} to material choice of every sword", "set {_a} to material choice of minecraft tag \"doors\""}).after(new String[]{"itemtype", "itemstack"}).since("1.10.0").parser((Parser)new Parser<RecipeChoice>(){

                public boolean canParse(ParseContext context) {
                    return false;
                }

                @NotNull
                public String toString(@NotNull RecipeChoice matChoice, int flags) {
                    return Types.recipeChoiceToString(matChoice);
                }

                @NotNull
                public String toVariableNameString(RecipeChoice matChoice) {
                    return "recipechoice:" + this.toString(matChoice, 0);
                }
            }));
        }
        EnumWrapper<RecipeType> RECIPE_TYPE_ENUM = new EnumWrapper<RecipeType>(RecipeType.class);
        Classes.registerClass((ClassInfo)RECIPE_TYPE_ENUM.getClassInfo("recipetype").user(new String[]{"recipe ?types?"}).name("Recipe Type").description(new String[]{"Represents the types of recipes."}).since("2.6.0"));
        Converters.registerConverter(ItemStack.class, RecipeChoice.class, from -> {
            Material material = from.getType();
            if (material.isAir() || !material.isItem()) {
                return null;
            }
            if (from.isSimilar(new ItemStack(material))) {
                return new RecipeChoice.MaterialChoice(material);
            }
            return new RecipeChoice.ExactChoice(from);
        });
        Converters.registerConverter(Tag.class, RecipeChoice.class, (Converter)new Converter<Tag, RecipeChoice>(){

            @Nullable
            public RecipeChoice convert(Tag from) {
                if (Util.isMaterialTag(from)) {
                    return new RecipeChoice.MaterialChoice(from);
                }
                return null;
            }
        });
    }
}

