/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.recipe.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.event.recipe.ShapelessRecipeCreateEvent;
import com.shanebeestudios.skbee.api.recipe.RecipeUtil;
import com.shanebeestudios.skbee.api.skript.base.Section;
import com.shanebeestudios.skbee.api.util.SimpleEntryValidator;
import com.shanebeestudios.skbee.api.util.Util;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.recipe.CraftingBookCategory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.entry.EntryContainer;
import org.skriptlang.skript.lang.entry.EntryValidator;

@Name(value="Recipe - Register Shapeless Recipe")
@Description(value={"This section allows you to register a shapeless recipe and add ingredients.", "\n`id` = The ID for your recipe. This is used for recipe discovery and Minecraft's /recipe command.", "\n`result` = The resulting item of this recipe.", "\n`group` = Define a group to group your recipes together in the recipe book", "(an example would be having 3 recipes with the same outcome but a variety of ingredients) (optional).", "\n`category` = The recipe book category your recipe will be in (optional) [Requires MC 1.19+].", "Options are \"building\", \"redstone\", \"equiptment\", \"misc\".", "\n`ingredients` = This section is where you will add the ingredients."})
@Examples(value={"on load:", "\tregister shapeless recipe:", "\t\tid: \"custom:string\"", "\t\tresult: 4 string", "\t\tingredients:", "\t\t\tadd material choice of every wool to ingredients", "", "\tregister shapeless recipe:", "\t\tid: \"custom:totem_of_undying\"", "\t\tresult: totem of undying", "\t\tgroup: \"custom tools\"", "\t\tcategory: \"redstone\"", "\t\tingredients:", "\t\t\tadd diamond block to ingredients", "\t\t\tadd material choice of every plank to ingredients", "\t\t\tadd emerald block to ingredients", "\t\t\tadd end rod to ingredients", "\t\t\tadd wither skeleton skull to ingredients", "", "\tregister shapeless recipe:", "\t\tid: \"custom:end_rod\"", "\t\tresult: end rod", "\t\tgroup: \"custom tools\"", "\t\tcategory: \"redstone\"", "\t\tingredients:", "\t\t\tadd diamond block to ingredients", "\t\t\tadd emerald block to ingredients"})
@Since(value={"3.0.0"})
public class SecRecipeShapeless
extends Section {
    private static final boolean HAS_CATEGORY = RecipeUtil.HAS_CATEGORY;
    private static final Map<String, CraftingBookCategory> CATEGORY_MAP = new HashMap<String, CraftingBookCategory>();
    private static final EntryValidator VALIDATOR;
    private Expression<String> id;
    private Expression<ItemStack> result;
    private Expression<String> group;
    private Expression<String> category;
    private Trigger ingredientSection;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, SectionNode sectionNode, List<TriggerItem> triggerItems) {
        EntryContainer container = VALIDATOR.validate(sectionNode);
        if (container == null) {
            return false;
        }
        this.id = (Expression)container.getOptional("id", false);
        if (this.id == null) {
            return false;
        }
        this.result = (Expression)container.getOptional("result", false);
        if (this.result == null) {
            return false;
        }
        this.group = (Expression)container.getOptional("group", false);
        this.category = HAS_CATEGORY ? (Expression)container.getOptional("category", false) : null;
        SectionNode ingredients = (SectionNode)container.get("ingredients", SectionNode.class, false);
        this.ingredientSection = this.loadCode(ingredients, "ingredients section", new Class[]{ShapelessRecipeCreateEvent.class});
        return true;
    }

    @Nullable
    protected TriggerItem walk(Event event) {
        this.execute(event);
        return super.walk(event, false);
    }

    private void execute(Event event) {
        String category;
        String group;
        Object localVars = Variables.copyLocalVariables((Event)event);
        String id = (String)this.id.getSingle(event);
        if (id == null) {
            this.error("Missing id");
            return;
        }
        NamespacedKey key = Util.getNamespacedKey(id, false);
        if (key == null) {
            this.error("Invalid id: " + id);
            return;
        }
        ItemStack result = (ItemStack)this.result.getSingle(event);
        if (result == null || result.getType().isAir() || !result.getType().isItem()) {
            this.error("Invalid result: " + String.valueOf(result));
            return;
        }
        ShapelessRecipe shapelessRecipe = new ShapelessRecipe(key, result);
        if (this.group != null && (group = (String)this.group.getSingle(event)) != null) {
            shapelessRecipe.setGroup(group);
        }
        if (this.category != null && (category = (String)this.category.getSingle(event)) != null && CATEGORY_MAP.containsKey(category)) {
            shapelessRecipe.setCategory(CATEGORY_MAP.get(category));
        }
        ShapelessRecipeCreateEvent recipeEvent = new ShapelessRecipeCreateEvent(shapelessRecipe);
        Variables.setLocalVariables((Event)recipeEvent, (Object)localVars);
        TriggerItem.walk((TriggerItem)this.ingredientSection, (Event)recipeEvent);
        Variables.setLocalVariables((Event)event, (Object)localVars);
        Variables.removeLocals((Event)recipeEvent);
        if (shapelessRecipe.getIngredientList().isEmpty()) {
            this.error("Missing ingredients");
            return;
        }
        Bukkit.removeRecipe((NamespacedKey)key);
        Bukkit.addRecipe((Recipe)shapelessRecipe);
        RecipeUtil.logShapelessRecipe(shapelessRecipe);
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "register shapeless recipe";
    }

    static {
        SimpleEntryValidator builder = SimpleEntryValidator.builder();
        builder.addRequiredEntry("id", String.class);
        builder.addRequiredEntry("result", ItemStack.class);
        builder.addOptionalEntry("group", String.class);
        if (HAS_CATEGORY) {
            builder.addOptionalEntry("category", String.class);
            for (CraftingBookCategory value : CraftingBookCategory.values()) {
                String name = value.name().toLowerCase(Locale.ROOT);
                CATEGORY_MAP.put(name, value);
            }
        }
        builder.addRequiredSection("ingredients");
        VALIDATOR = builder.build();
        Skript.registerSection(SecRecipeShapeless.class, (String[])new String[]{"register [a] [new] shapeless recipe"});
    }
}

