/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.recipe.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.util.Util;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Recipe - Result")
@Description(value={"Get the result item of a recipe.", "\nID = Minecraft or custom NamespacedKey, see examples."})
@Examples(value={"set {_result} to result of recipe \"minecraft:oak_door\"", "set {_result} to result of recipe \"skbee:some_recipe\"", "set {_result} to result of recipe \"my_recipes:some_custom_recipe\""})
@Since(value={"2.6.0"})
public class ExprRecipeResult
extends SimpleExpression<ItemType> {
    private Expression<String> key;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.key = exprs[0];
        return true;
    }

    @Nullable
    protected ItemType[] get(Event event) {
        ArrayList<ItemType> items = new ArrayList<ItemType>();
        for (String key : (String[])this.key.getArray(event)) {
            Recipe recipe;
            NamespacedKey namespacedKey = Util.getNamespacedKey(key, false);
            if (namespacedKey == null || (recipe = Bukkit.getRecipe((NamespacedKey)namespacedKey)) == null) continue;
            ItemStack result = recipe.getResult();
            items.add(new ItemType(result));
        }
        return items.toArray(new ItemType[0]);
    }

    public boolean isSingle() {
        return this.key.isSingle();
    }

    @NotNull
    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "result[s] of recipe[s] " + this.key.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprRecipeResult.class, ItemType.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"result[s] of recipe[s] [with id[s]] %strings%"});
    }
}

