/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.recipe.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.util.Util;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Event;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.SmithingRecipe;
import org.bukkit.inventory.StonecuttingRecipe;
import org.jetbrains.annotations.Nullable;

@Name(value="Recipe - Ingredients of Recipe")
@Description(value={"Get the ingredients from a recipe. Requires 1.13+"})
@Examples(value={"set {_ing::*} to ingredients of recipe \"minecraft:diamond_sword\"", "loop recipes for iron ingot:", "\tset {_ing::*} to ingredients of recipe %loop-value%"})
@Since(value={"1.4.0"})
public class ExprIngredientsOfRecipe
extends SimpleExpression<ItemType> {
    private Expression<String> recipe;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.recipe = exprs[0];
        return true;
    }

    @Nullable
    protected ItemType[] get(Event event) {
        Keyed keyed;
        String recipeSingle = (String)this.recipe.getSingle(event);
        if (recipeSingle == null) {
            return null;
        }
        NamespacedKey namespacedKey = Util.getNamespacedKey(recipeSingle, false);
        if (namespacedKey == null) {
            return null;
        }
        ArrayList<ItemType> items = new ArrayList<ItemType>();
        Recipe recipe = Bukkit.getRecipe((NamespacedKey)namespacedKey);
        if (recipe instanceof Keyed && (keyed = (Keyed)recipe).getKey().equals((Object)namespacedKey)) {
            if (recipe instanceof ShapedRecipe) {
                ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
                String[] shape = shapedRecipe.getShape();
                int length = Math.max(shape.length, shape[0].length());
                int i = 0;
                while ((double)i < Math.pow(length, 2.0)) {
                    items.add(new ItemType(Material.AIR));
                    ++i;
                }
                for (i = 0; i < shape.length; ++i) {
                    for (int x = 0; x < shape[i].length(); ++x) {
                        ItemStack ingredient = (ItemStack)shapedRecipe.getIngredientMap().get(Character.valueOf(shape[i].toCharArray()[x]));
                        if (ingredient == null) continue;
                        items.set(i * length + x, new ItemType(ingredient));
                    }
                }
            } else if (recipe instanceof ShapelessRecipe) {
                ShapelessRecipe shapelessRecipe = (ShapelessRecipe)recipe;
                for (ItemStack ingredient : shapelessRecipe.getIngredientList()) {
                    if (ingredient == null) continue;
                    items.add(new ItemType(ingredient));
                }
            } else if (recipe instanceof CookingRecipe) {
                CookingRecipe cookingRecipe = (CookingRecipe)recipe;
                items.add(new ItemType(cookingRecipe.getInput()));
            } else if (recipe instanceof MerchantRecipe) {
                MerchantRecipe merchantRecipe = (MerchantRecipe)recipe;
                for (ItemStack ingredient : merchantRecipe.getIngredients()) {
                    if (ingredient == null) continue;
                    items.add(new ItemType(ingredient));
                }
            } else if (recipe instanceof StonecuttingRecipe) {
                StonecuttingRecipe stonecuttingRecipe = (StonecuttingRecipe)recipe;
                items.add(new ItemType(stonecuttingRecipe.getInput()));
            } else if (recipe instanceof SmithingRecipe) {
                SmithingRecipe smithingRecipe = (SmithingRecipe)recipe;
                items.add(new ItemType(smithingRecipe.getBase().getItemStack()));
                items.add(new ItemType(smithingRecipe.getAddition().getItemStack()));
            }
        }
        return items.toArray(new ItemType[0]);
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    public String toString(@Nullable Event e, boolean d) {
        return "ingredients of recipe " + this.recipe.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprIngredientsOfRecipe.class, ItemType.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[(all [[of] the]|the)] ingredients (for|of) recipe %string%"});
    }
}

