/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.recipe.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.recipe.RecipeUtil;
import com.shanebeestudios.skbee.api.util.Util;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.SmithingRecipe;
import org.jetbrains.annotations.NotNull;

@Name(value="Recipe - Smithing")
@Description(value={"Register a new smithing recipe.", "The ID will be the name given to this recipe. IDs may only contain letters, numbers, periods, hyphens, a single colon and underscores,", "NOT SPACES!!! By default, if no namespace is provided, recipes will start with the namespace \"minecraft:\",", "this can be changed in the config to whatever you want. IDs are used for recipe discovery/unlocking recipes for players.", "Note: While 'custom' items will work in these recipes, it appears the smithing table will not recognize them. Requires MC 1.16+", "\n<b>NOTE:</b>Temporarily removed in 1.20+ as Minecraft has changed how these recipes work!"})
@Examples(value={"on load:", "\tregister new smithing recipe for diamond chestplate using an iron chestplate and a diamond with id \"smith_diamond_chestplate\""})
@Since(value={"1.4.2"})
public class EffSmithingRecipe
extends Effect {
    private Expression<ItemType> result;
    private Expression<Object> base;
    private Expression<Object> addition;
    private Expression<String> key;

    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parse) {
        this.result = exprs[0];
        this.base = exprs[1];
        this.addition = exprs[2];
        this.key = exprs[3];
        if (Util.IS_RUNNING_MC_1_20) {
            Skript.error((String)"Smithing recipes have been temporarily removed as Minecraft has changed how these recipes work!");
            return false;
        }
        return true;
    }

    protected void execute(@NotNull Event event) {
        ItemType result = (ItemType)this.result.getSingle(event);
        Object base = this.base.getSingle(event);
        Object addition = this.addition.getSingle(event);
        if (result == null) {
            RecipeUtil.error("Error registering smithing recipe - result is null");
            RecipeUtil.error("Current Item: \u00a76" + this.toString(event, true));
            return;
        }
        if (base == null) {
            RecipeUtil.error("Error registering smithing recipe - base is null");
            RecipeUtil.error("Current Item: \u00a76" + this.toString(event, true));
            return;
        }
        if (addition == null) {
            RecipeUtil.error("Error registering smithing recipe - addition is null");
            RecipeUtil.error("Current Item: \u00a76" + this.toString(event, true));
            return;
        }
        NamespacedKey key = Util.getNamespacedKey((String)this.key.getSingle(event), false);
        if (key == null) {
            RecipeUtil.error("Current Item: \u00a76'" + this.toString(event, true) + "'");
            return;
        }
        Bukkit.removeRecipe((NamespacedKey)key);
        ItemStack resultStack = result.getRandom();
        RecipeChoice choiceBase = this.getChoice(base);
        RecipeChoice choiceAddition = this.getChoice(addition);
        if (resultStack == null || choiceBase == null || choiceAddition == null) {
            return;
        }
        SmithingRecipe recipe = new SmithingRecipe(key, resultStack, choiceBase, choiceAddition);
        Bukkit.addRecipe((Recipe)recipe);
        if (SkBee.isDebug()) {
            RecipeUtil.logRecipe((Recipe)recipe, recipe.getBase(), recipe.getAddition());
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "Register new smithing recipe for " + this.result.toString(e, d) + " using " + this.base.toString(e, d) + " and " + this.addition.toString(e, d) + " with id " + this.key.toString(e, d);
    }

    private RecipeChoice getChoice(Object object) {
        if (object instanceof ItemType) {
            Material material;
            ItemType itemType = (ItemType)object;
            ItemStack itemStack = itemType.getRandom();
            if (itemStack.isSimilar(new ItemStack(material = itemStack.getType()))) {
                return new RecipeChoice.MaterialChoice(material);
            }
            return new RecipeChoice.ExactChoice(itemStack);
        }
        if (object instanceof RecipeChoice.MaterialChoice) {
            return (RecipeChoice.MaterialChoice)object;
        }
        return null;
    }

    static {
        Skript.registerEffect(EffSmithingRecipe.class, (String[])new String[]{"register [new] smithing recipe for %itemtype% using %itemtype/recipechoice% and %itemtype/recipechoice% with id %string%"});
    }
}

