/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.recipe.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.SkBee;
import com.shanebeestudios.skbee.api.recipe.RecipeUtil;
import com.shanebeestudios.skbee.api.util.Util;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;

@Name(value="Recipe - Shaped/Shapeless")
@Description(value={"Register a new shaped/shapeless recipe for a specific item using custom ingredients.", "Recipes support items and material choices for ingredients. Material choices allow you to use Minecraft tags or lists of items.", "The ID will be the name given to this recipe. IDs may only contain letters, numbers, periods, hyphens, a single colon and underscores,", "NOT SPACES!!! By default, if no namespace is provided, recipes will start with the namespace \"minecraft:\",", "this can be changed in the config to whatever you want. IDs are used for recipe discovery/unlocking recipes for players.", "You may also include an optional group for recipes. These will group the recipes together in the recipe book.", "<b>NOTE:</b> Recipes with 4 or less ingredients will be craftable in the player's crafting grid.", "Requires MC 1.13+"})
@Examples(value={"on load:", "\tregister new shaped recipe for elytra using air, iron chestplate, air, air, iron chestplate and air with id \"my_recipes:elytra\"", "\tset {_s} to emerald named \"&3Strong Emerald\"", "\tregister new shaped recipe for {_s} using emerald, emerald, air, emerald, emerald and air with id \"strong_emerald\"", "\tregister new shaped recipe for diamond chestplate named \"&3Strong Emerald Chestplate\" using {_s}, air, {_s}, {_s}, {_s}, {_s}, {_s}, {_s} and {_s} with id \"strong_emerald_chestplate\"", "", "\tset {_a} to material choice of every plank", "\tregister new shaped recipe for jigsaw block using {_a}, {_a}, {_a}, {_a}, {_a}, {_a}, {_a}, {_a} and {_a} with id \"jigsaw\""})
@RequiredPlugins(value={"1.13+"})
@Since(value={"1.0.0"})
public class EffCraftingRecipe
extends Effect {
    private Expression<ItemType> item;
    private Expression<Object> ingredients;
    private Expression<String> id;
    private Expression<String> group;
    private boolean shaped;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.item = exprs[0];
        this.ingredients = exprs[1];
        this.id = exprs[2];
        this.group = exprs[3];
        this.shaped = parseResult.mark == 0;
        return true;
    }

    protected void execute(Event event) {
        ItemType item = (ItemType)this.item.getSingle(event);
        Object[] ingredients = this.ingredients.getAll(event);
        if (item == null) {
            RecipeUtil.error("Error registering crafting recipe - result is null");
            RecipeUtil.error("Current Item: \u00a76" + this.toString(event, true));
            return;
        }
        if (ingredients.length == 0) {
            RecipeUtil.error("Error registering crafting recipe - a minimum of at least 1 ingredient needs to be defined");
            RecipeUtil.error("Current Item: \u00a76" + this.toString(event, true));
            return;
        }
        if (ingredients.length > 9) {
            RecipeUtil.error("Error registering crafting recipe - a maximum of 9 ingredients can be defined");
            RecipeUtil.error("Current Item: &6" + this.toString(event, true));
            return;
        }
        String group = this.group != null ? (String)this.group.getSingle(event) : null;
        String id = (String)this.id.getSingle(event);
        NamespacedKey key = Util.getNamespacedKey(id, false);
        if (key == null) {
            RecipeUtil.error("Current Item: \u00a76'" + this.toString(event, true) + "'");
            return;
        }
        Bukkit.removeRecipe((NamespacedKey)key);
        if (this.shaped) {
            this.registerShaped(item, ingredients, key, group);
        } else {
            this.registerShapeless(item, ingredients, key, group);
        }
    }

    private void registerShaped(ItemType item, Object[] ingredients, NamespacedKey key, String group) {
        Object object;
        boolean craftingTable = ingredients.length > 4;
        ShapedRecipe recipe = new ShapedRecipe(key, item.getRandom());
        if (group != null) {
            recipe.setGroup(group);
        }
        Character[] oldChar = new Character[]{Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9')};
        Character[] keyChar = new Character[9];
        for (int i = 0; i < 9; ++i) {
            ItemType itemType;
            Object object2 = object = ingredients.length > i ? ingredients[i] : null;
            keyChar[i] = ingredients.length - 1 < i ? Character.valueOf(' ') : (object instanceof ItemType && (itemType = (ItemType)object).getMaterial() == Material.AIR ? Character.valueOf(' ') : oldChar[i]);
        }
        if (craftingTable) {
            one = "" + keyChar[0] + keyChar[1] + keyChar[2];
            two = "" + keyChar[3] + keyChar[4] + keyChar[5];
            String thr = "" + keyChar[6] + keyChar[7] + keyChar[8];
            ArrayList<CallSite> shape = new ArrayList<CallSite>();
            if (!one.equalsIgnoreCase("   ")) {
                shape.add((CallSite)((Object)one));
            }
            if (!two.equalsIgnoreCase("   ")) {
                shape.add((CallSite)((Object)two));
            }
            if (!thr.equalsIgnoreCase("   ")) {
                shape.add((CallSite)((Object)thr));
            }
            recipe.shape(shape.toArray(new String[0]));
        } else {
            one = "" + keyChar[0] + keyChar[1];
            two = "" + keyChar[2] + keyChar[3];
            ArrayList<CallSite> shape = new ArrayList<CallSite>();
            if (!one.equalsIgnoreCase("  ")) {
                shape.add((CallSite)((Object)one));
            }
            if (!two.equalsIgnoreCase("  ")) {
                shape.add((CallSite)((Object)two));
            }
            recipe.shape(shape.toArray(new String[0]));
        }
        for (int i = 0; i < ingredients.length; ++i) {
            object = ingredients[i];
            if (object instanceof ItemType) {
                ItemStack itemStack = ((ItemType)object).getRandom();
                Material material = itemStack.getType();
                if (material == Material.AIR || !material.isItem()) continue;
                if (itemStack.isSimilar(new ItemStack(material))) {
                    recipe.setIngredient(keyChar[i].charValue(), material);
                    continue;
                }
                recipe.setIngredient(keyChar[i].charValue(), (RecipeChoice)new RecipeChoice.ExactChoice(itemStack));
                continue;
            }
            if (!(object instanceof RecipeChoice)) continue;
            RecipeChoice recipeChoice = (RecipeChoice)object;
            recipe.setIngredient(keyChar[i].charValue(), recipeChoice);
        }
        if (SkBee.isDebug()) {
            RecipeUtil.logShapedRecipe(recipe);
        }
        Bukkit.addRecipe((Recipe)recipe);
    }

    private void registerShapeless(ItemType item, Object[] ingredients, NamespacedKey key, String group) {
        ShapelessRecipe recipe = new ShapelessRecipe(key, item.getRandom());
        if (group != null) {
            recipe.setGroup(group);
        }
        for (Object ingredient : ingredients) {
            if (ingredient instanceof ItemType) {
                ItemStack itemStack = ((ItemType)ingredient).getRandom();
                Material material = itemStack.getType();
                if (material != Material.AIR && material.isItem()) {
                    if (itemStack.isSimilar(new ItemStack(material))) {
                        recipe.addIngredient(material);
                        continue;
                    }
                    recipe.addIngredient((RecipeChoice)new RecipeChoice.ExactChoice(itemStack));
                    continue;
                }
                if (!SkBee.isDebug()) continue;
                RecipeUtil.warn("ERROR LOADING RECIPE: &7(&b" + key.getKey() + "&7)");
                RecipeUtil.warn("Non item &b" + ((ItemType)ingredient).toString(0) + "&e found, this item will be removed from the recipe.");
                continue;
            }
            if (!(ingredient instanceof RecipeChoice)) continue;
            RecipeChoice recipeChoice = (RecipeChoice)ingredient;
            recipe.addIngredient(recipeChoice);
        }
        Bukkit.addRecipe((Recipe)recipe);
        if (SkBee.isDebug()) {
            RecipeUtil.logShapelessRecipe(recipe);
        }
    }

    public String toString(Event e, boolean d) {
        return String.format("Register new %s recipe for %s using %s with id '%s' %s", this.shaped ? "shaped" : "shapeless", this.item.toString(e, d), this.ingredients.toString(e, d), this.id.toString(e, d), this.group != null ? "in group " + this.group.toString(e, d) : "");
    }

    static {
        Skript.registerEffect(EffCraftingRecipe.class, (String[])new String[]{"register [new] (shaped|1:shapeless) recipe for %itemtype% (using|with ingredients) %itemtypes/recipechoices% with id %string% [in group %-string%]"});
    }
}

