/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.raytrace.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.util.RayTraceResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="RayTrace - Hit Location")
@Description(value={"Get the hit location resulting from a RayTrace."})
@Examples(value={"set {_hit} to hit location of {_ray}"})
@Since(value={"2.6.0"})
public class ExprRayTraceHitLocation
extends SimplePropertyExpression<RayTraceResult, Location> {
    @Nullable
    public Location convert(RayTraceResult rayTraceResult) {
        World world;
        Block hitBlock = rayTraceResult.getHitBlock();
        Entity hitEntity = rayTraceResult.getHitEntity();
        if (hitBlock != null) {
            world = hitBlock.getWorld();
        } else if (hitEntity != null) {
            world = hitEntity.getWorld();
        } else {
            return null;
        }
        return rayTraceResult.getHitPosition().toLocation(world);
    }

    @NotNull
    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "ray trace hit location";
    }

    static {
        ExprRayTraceHitLocation.register(ExprRayTraceHitLocation.class, Location.class, (String)"[ray[ ]trace] hit location", (String)"raytraceresults");
    }
}

