/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.raytrace.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.util.EntityUtils;
import java.util.ArrayList;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="RayTrace - From Entity")
@Description(value={"RayTrace from an entity.", "\nDefault max distance = 'maximum target block distance' in Skript's config.", "\nRaySize = entity bounding boxes will be uniformly expanded (or shrunk)", "by this value before doing collision checks (default = 0.0).", "\nIngorePassableBlocks = Will ignore passable but collidable blocks (ex. tall grass, signs, fluids, ..). [Added in SkBee 3.0.0]", "\nIgnoring Entities/EntityTypes = Will ignore the entities/entitytypes from the final ray. [Added in SkBee 3.5.0]"})
@Examples(value={"set {_ray} to ray trace from player with max distance 25", "set {_ray} to ray trace from player with max distance 25 while ignoring passable blocks", "set {_rays::*} to raytrace from all players with ray size 0.1"})
@Since(value={"2.6.0"})
public class ExprRayTraceFromEntity
extends SimpleExpression<RayTraceResult> {
    private Expression<LivingEntity> entities;
    private Expression<Number> maxDistance;
    private Expression<Number> raySize;
    private boolean ignore;
    private Expression<?> ignored;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entities = exprs[0];
        this.maxDistance = exprs[1];
        this.raySize = exprs[2];
        this.ignore = parseResult.hasTag("ignore");
        this.ignored = exprs[3];
        return true;
    }

    @Nullable
    protected RayTraceResult[] get(Event event) {
        Number raySizeNum;
        Number maxDistanceNum;
        Object[] ignored = this.ignored != null ? this.ignored.getArray(event) : null;
        int maxDistance = (Integer)SkriptConfig.maxTargetBlockDistance.value();
        if (this.maxDistance != null && (maxDistanceNum = (Number)this.maxDistance.getSingle(event)) != null) {
            maxDistance = maxDistanceNum.intValue();
        }
        double raySize = 0.0;
        if (this.raySize != null && (raySizeNum = (Number)this.raySize.getSingle(event)) != null) {
            raySize = raySizeNum.doubleValue();
        }
        ArrayList<RayTraceResult> results = new ArrayList<RayTraceResult>();
        for (LivingEntity livingEntity : (LivingEntity[])this.entities.getArray(event)) {
            World world = livingEntity.getWorld();
            Location location = livingEntity.getEyeLocation();
            Vector direction = location.getDirection();
            RayTraceResult rayTraceResult = world.rayTrace(location, direction, (double)maxDistance, FluidCollisionMode.NEVER, this.ignore, raySize, EntityUtils.filter(livingEntity, ignored));
            results.add(rayTraceResult);
        }
        return results.toArray(new RayTraceResult[0]);
    }

    public boolean isSingle() {
        return this.entities.isSingle();
    }

    @NotNull
    public Class<? extends RayTraceResult> getReturnType() {
        return RayTraceResult.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String max = this.maxDistance != null ? " with max distance " + this.maxDistance.toString(e, d) : "";
        String size = this.raySize != null ? " with ray size " + this.raySize.toString(e, d) : "";
        String ignore = this.ignore ? " while ignoring passable blocks" : "";
        String ignored = this.ignored != null ? " while ignoring " + this.ignored.toString(e, d) : "";
        return "ray trace from " + this.entities.toString(e, d) + max + size + ignore + ignored;
    }

    static {
        Skript.registerExpression(ExprRayTraceFromEntity.class, RayTraceResult.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"ray[ ]trace from %livingentities% [with max distance %-number%] [with ray size %-number%] [ignore:while ignoring passable blocks] [while ignoring %-entities/entitydatas%]"});
    }
}

