/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.property.properties;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import com.shanebeestudios.skbee.api.property.Property;
import com.shanebeestudios.skbee.api.property.PropertyRegistry;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Locale;
import org.bukkit.inventory.ItemRarity;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Nullable;

public class ItemProperties {
    static {
        PropertyRegistry.registerProperty("blast resistance", new Property<ItemType, Float>(ItemType.class, Float.class){

            @Override
            public Float get(ItemType itemType) {
                return Float.valueOf(itemType.getMaterial().getBlastResistance());
            }
        }).description("Represents the blast resistance of a block.").examples("if blast resistance property of target block > 1:").since("3.10.0");
        PropertyRegistry.registerProperty("fire resistant", new Property<ItemType, Boolean>(ItemType.class, Boolean.class){

            @Override
            public Boolean get(ItemType itemType) {
                return itemType.getItemMeta().isFireResistant();
            }

            @Override
            public void set(ItemType itemType, Boolean value) {
                ItemMeta itemMeta = itemType.getItemMeta();
                itemMeta.setFireResistant(value.booleanValue());
                itemType.setItemMeta(itemMeta);
            }
        }).description("Represents if an item is fire resistant. If true, it will not burn in fire or lava.").examples("set fire resistant property of {_i} to true").since("3.10.0");
        if (Skript.classExists((String)"org.bukkit.inventory.ItemRarity")) {
            ArrayList<CallSite> rarityNames = new ArrayList<CallSite>();
            for (ItemRarity value : ItemRarity.values()) {
                rarityNames.add((CallSite)((Object)("\"" + value.name().toLowerCase(Locale.ROOT) + "\"")));
            }
            PropertyRegistry.registerProperty("item rarity", new Property<ItemType, String>(ItemType.class, String.class){

                @Override
                @Nullable
                public String get(ItemType itemType) {
                    ItemMeta itemMeta = itemType.getItemMeta();
                    ItemRarity rarity = itemMeta.hasRarity() ? itemMeta.getRarity() : itemType.getMaterial().asItemType().getItemRarity();
                    if (rarity == null) {
                        return null;
                    }
                    return rarity.toString().toLowerCase(Locale.ROOT);
                }

                @Override
                public void set(ItemType itemType, String value) {
                    ItemRarity itemRarity;
                    try {
                        itemRarity = ItemRarity.valueOf((String)value.toUpperCase(Locale.ROOT));
                    }
                    catch (IllegalArgumentException ignore) {
                        itemRarity = ItemRarity.COMMON;
                    }
                    ItemMeta itemMeta = itemType.getItemMeta();
                    itemMeta.setRarity(itemRarity);
                    itemType.setItemMeta(itemMeta);
                }

                @Override
                public void delete(ItemType itemType) {
                    ItemMeta itemMeta = itemType.getItemMeta();
                    itemMeta.setRarity(null);
                    itemType.setItemMeta(itemMeta);
                }
            }).description("Represents the different item rarities of an item (represented as a string).", "Options are: " + String.join((CharSequence)", ", rarityNames), "Requires MC 1.20.5+").examples("set item rarity property of player's tool to \"uncommon\"", "set {_rarity} to item rarity property of player's tool", "if item rarity property of player's tool = \"epic\":").since("3.10.0");
        }
        PropertyRegistry.registerProperty("unbreakable", new Property<ItemType, Boolean>(ItemType.class, Boolean.class){

            @Override
            public Boolean get(ItemType itemType) {
                return itemType.getItemMeta().isUnbreakable();
            }

            @Override
            public void set(ItemType itemType, Boolean value) {
                ItemMeta itemMeta = itemType.getItemMeta();
                itemMeta.setUnbreakable(value.booleanValue());
                itemType.setItemMeta(itemMeta);
            }
        }).description("Represents if the item is unbreakable.").examples("set unbreakable property of player's tool to true", "set unbreakable property of player's tool to false").since("3.10.0");
    }
}

