/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.particle.type;

import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.function.Functions;
import ch.njol.skript.lang.function.JavaFunction;
import ch.njol.skript.lang.function.Parameter;
import ch.njol.skript.lang.function.SimpleJavaFunction;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.DefaultClasses;
import ch.njol.skript.util.Color;
import ch.njol.skript.util.SkriptColor;
import ch.njol.skript.util.Timespan;
import com.shanebeestudios.skbee.api.particle.ParticleUtil;
import com.shanebeestudios.skbee.api.util.SkriptUtils;
import com.shanebeestudios.skbee.api.util.Util;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Vibration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Types {
    static {
        if (Classes.getExactClassInfo(Particle.class) == null) {
            Classes.registerClass((ClassInfo)new ClassInfo(Particle.class, "particle").user(new String[]{"particles?"}).name("Particle").description(new String[]{"Represents a particle which can be used in the 'Particle Spawn' effect.", "Some particles require extra data, these are distinguished by their data type within the square brackets.", "DustOption, DustTransition and Vibration each have their own functions to build the appropriate data for these particles.", "NOTE: These are auto-generated and may differ between server versions."}).usage(new String[]{ParticleUtil.getNamesAsString()}).after(new String[]{"itemtype"}).since("1.9.0").parser((Parser)new Parser<Particle>(){

                @Nullable
                public Particle parse(String s, ParseContext context) {
                    return ParticleUtil.parse(s.replace(" ", "_"));
                }

                @NotNull
                public String toString(Particle particle, int flags) {
                    return ParticleUtil.getName(particle);
                }

                @NotNull
                public String toVariableNameString(Particle particle) {
                    return "particle:" + this.toString(particle, 0);
                }
            }));
        } else {
            Util.logLoading("It looks like another addon registered 'particle' already.", new Object[0]);
            Util.logLoading("You may have to use their particles in SkBee's 'particle spawn' effect.", new Object[0]);
        }
        if (Classes.getExactClassInfo(Particle.DustOptions.class) == null) {
            Classes.registerClass((ClassInfo)new ClassInfo(Particle.DustOptions.class, "dustoption").name(ClassInfo.NO_DOC).user(new String[]{"dust ?options?"}).parser((Parser)new Parser<Particle.DustOptions>(){

                public boolean canParse(ParseContext context) {
                    return false;
                }

                @NotNull
                public String toString(Particle.DustOptions dustOption, int flags) {
                    org.bukkit.Color bukkitColor = dustOption.getColor();
                    int red = bukkitColor.getRed();
                    int green = bukkitColor.getGreen();
                    int blue = bukkitColor.getBlue();
                    SkriptColor skriptColor = SkriptColor.fromBukkitColor((org.bukkit.Color)bukkitColor);
                    String color = skriptColor != null ? skriptColor.toString() : String.format("rgb(%s,%s,%s)", red, green, blue);
                    return "dustOption(color=" + color + ",size=" + dustOption.getSize() + ")";
                }

                @NotNull
                public String toVariableNameString(Particle.DustOptions o) {
                    return this.toString(o, 0);
                }
            }));
        }
        if (Classes.getExactClassInfo(Particle.DustTransition.class) == null) {
            Classes.registerClass((ClassInfo)new ClassInfo(Particle.DustTransition.class, "dusttransition").name(ClassInfo.NO_DOC).user(new String[]{"dust ?transitions?"}).parser(SkriptUtils.getDefaultParser()));
        }
        if (Classes.getExactClassInfo(Vibration.class) == null) {
            Classes.registerClass((ClassInfo)new ClassInfo(Vibration.class, "vibration").name(ClassInfo.NO_DOC).user(new String[]{"vibrations?"}).parser(SkriptUtils.getDefaultParser()));
        }
        if (ParticleUtil.HAS_TRAIL && Classes.getExactClassInfo(Particle.Trail.class) == null) {
            Classes.registerClass((ClassInfo)new ClassInfo(Particle.Trail.class, "trail").name(ClassInfo.NO_DOC).user(new String[]{"trails?"}).parser(SkriptUtils.getDefaultParser()));
        }
        Functions.registerFunction((JavaFunction)new SimpleJavaFunction<Particle.DustOptions>("dustOption", new Parameter[]{new Parameter("color", DefaultClasses.COLOR, true, null), new Parameter("size", DefaultClasses.NUMBER, true, null)}, Classes.getExactClassInfo(Particle.DustOptions.class), true){

            public Particle.DustOptions[] executeSimple(Object[][] params) {
                org.bukkit.Color color = ((Color)params[0][0]).asBukkitColor();
                float size = ((Number)params[1][0]).floatValue();
                return new Particle.DustOptions[]{new Particle.DustOptions(color, size)};
            }
        }.description(new String[]{"Creates a new dust option to be used with 'dust' particle. Color can either be a regular color or an RGB color using", "Skript's rgb() function. Size is the size the particle will be."}).examples(new String[]{"set {_c} to dustOption(red, 1.5)", "set {_c} to dustOption(rgb(1, 255, 1), 3)"}).since("1.9.0"));
        Functions.registerFunction((JavaFunction)new SimpleJavaFunction<Particle.DustTransition>("dustTransition", new Parameter[]{new Parameter("fromColor", DefaultClasses.COLOR, true, null), new Parameter("toColor", DefaultClasses.COLOR, true, null), new Parameter("size", DefaultClasses.NUMBER, true, null)}, Classes.getExactClassInfo(Particle.DustTransition.class), true){

            public Particle.DustTransition[] executeSimple(Object[][] params) {
                org.bukkit.Color fromColor = ((Color)params[0][0]).asBukkitColor();
                org.bukkit.Color toColor = ((Color)params[1][0]).asBukkitColor();
                float size = ((Number)params[2][0]).floatValue();
                return new Particle.DustTransition[]{new Particle.DustTransition(fromColor, toColor, size)};
            }
        }.description(new String[]{"Creates a new dust transition to be used with 'dust_color_transition' particle.", "Color can either be a regular color or an RGB color using Skript's rgb() function.", "Size is the size the particle will be. Requires MC 1.17+"}).examples(new String[]{"set {_d} to dustTransition(red, green, 10)", "set {_d} to dustTransition(blue, rgb(1,1,1), 5)"}).since("1.11.1"));
        Functions.registerFunction((JavaFunction)new SimpleJavaFunction<Vibration>("vibration", new Parameter[]{new Parameter("to", DefaultClasses.LOCATION, true, null), new Parameter("arrivalTime", DefaultClasses.TIMESPAN, true, null)}, Classes.getExactClassInfo(Vibration.class), true){

            public Vibration[] executeSimple(Object[][] params) {
                if (params[0].length == 0 || params[1].length == 0) {
                    return null;
                }
                Location origin = new Location(null, 0.0, 0.0, 0.0);
                Location destination = (Location)params[0][0];
                int arrivalTime = (int)((Timespan)params[1][0]).getAs(Timespan.TimePeriod.TICK);
                Vibration vibration = new Vibration(origin, (Vibration.Destination)new Vibration.Destination.BlockDestination(destination), arrivalTime);
                return new Vibration[]{vibration};
            }
        }.description(new String[]{"Creates a new vibration to be used with 'vibration' particle.", "TO = the destination location the particle will travel to.", "ARRIVAL TIME = the time it will take to arrive at the destination location.", "Requires MC 1.17+"}).examples(new String[]{"set {_v} to vibration({loc}, 10 seconds)"}).since("1.11.1"));
        if (ParticleUtil.HAS_TRAIL) {
            Functions.registerFunction((JavaFunction)new SimpleJavaFunction<Particle.Trail>("trail", new Parameter[]{new Parameter("target", DefaultClasses.LOCATION, true, null), new Parameter("color", DefaultClasses.COLOR, true, null), new Parameter("duration", DefaultClasses.TIMESPAN, true, null)}, Classes.getExactClassInfo(Particle.Trail.class), true){

                public Particle.Trail[] executeSimple(Object[][] params) {
                    Location target = (Location)params[0][0];
                    org.bukkit.Color color = ((Color)params[1][0]).asBukkitColor();
                    Timespan timespan = (Timespan)params[2][0];
                    return new Particle.Trail[]{new Particle.Trail(target, color, (int)timespan.getAs(Timespan.TimePeriod.TICK))};
                }
            }).description(new String[]{"Creates a new trail to be used with 'trail' particle.", "Takes in a location for the target (where the trail heads to), the color and duration.", "Requires Minecraft 1.21.4+"}).examples(new String[]{"set {_trail} to trail(location of target block, blue, 1 second)", "make 10 of trail using {_trail} at location of player"}).since("3.6.5");
        }
    }
}

