/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.skript.base.Section;
import com.shanebeestudios.skbee.api.util.Util;
import com.shanebeestudios.skbee.elements.other.expressions.ExprTransferCookie;
import java.util.List;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Transfer - Retrieve Cookie")
@Description(value={"Retrieve a cookie from a player. Requires Minecraft 1.20.5+", "Due to the retrieval process happening async, this will delay proceeding code.", "While the cookie is being retrieved, the following code will wait.", "NOTE: Cookies are stored across server transfers."})
@Examples(value={"command /server <string>:", "\ttrigger:", "\t\tstore cookie \"%uuid of player%-transfer\" with key \"transfer\" on player", "\t\ttransfer player to arg-1", "", "# Connect event is recommended over join event", "# This way if you have to kick the player it's done before they join", "on connect:", "\t# only do a cookie check if player was transferred", "\tif player is transferred:", "\t\tretrieve cookie with key \"transfer\" from player:", "\t\t\tif transfer cookie = \"%uuid of player%-transfer\":", "\t\t\t\t# stop code if cookie is correct", "\t\t\t\tstop", "\t\t# kick player if cookie is missing or incorrect", "\t\tkick player due to \"&cIllegal Transfer\""})
@Since(value={"3.5.3"})
public class SecTransferCookieRetrieve
extends Section {
    private Expression<?> key;
    private Expression<Player> player;
    static final /* synthetic */ boolean $assertionsDisabled;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, SectionNode sectionNode, List<TriggerItem> triggerItems) {
        this.key = exprs[0];
        this.player = exprs[1];
        ParserInstance parserInstance = ParserInstance.get();
        Kleenean hasDelayBefore = parserInstance.getHasDelayBefore();
        parserInstance.setHasDelayBefore(Kleenean.TRUE);
        if (!$assertionsDisabled && parserInstance.getCurrentEvents() == null) {
            throw new AssertionError();
        }
        this.loadCode(sectionNode);
        parserInstance.setHasDelayBefore(hasDelayBefore);
        return true;
    }

    @Nullable
    protected TriggerItem walk(Event event) {
        TriggerItem next = this.getNext();
        Object localVars = Variables.copyLocalVariables((Event)event);
        Player player = (Player)this.player.getSingle(event);
        Object keyObject = this.key.getSingle(event);
        if (player == null || keyObject == null) {
            return null;
        }
        NamespacedKey key = null;
        if (keyObject instanceof String) {
            String string = (String)keyObject;
            key = Util.getNamespacedKey(string, false);
        } else if (keyObject instanceof NamespacedKey) {
            NamespacedKey namespacedKey;
            key = namespacedKey = (NamespacedKey)keyObject;
        }
        if (key == null) {
            this.error("Key is invalid: " + String.valueOf(keyObject));
            return next;
        }
        player.retrieveCookie(key).thenAccept(bytes -> {
            Delay.addDelayedEvent((Event)event);
            ExprTransferCookie.setLastTransferCookie(bytes != null ? new String((byte[])bytes) : null);
            if (localVars != null) {
                Variables.setLocalVariables((Event)event, (Object)localVars);
            }
            if (this.first != null) {
                TriggerItem.walk((TriggerItem)this.first, (Event)event);
            }
            Variables.removeLocals((Event)event);
            ExprTransferCookie.setLastTransferCookie(null);
        });
        return null;
    }

    @NotNull
    public String toString(Event e, boolean d) {
        return String.format("retrieve cookie with key %s from %s", this.key.toString(e, d), this.player.toString(e, d));
    }

    static {
        boolean bl = $assertionsDisabled = !SecTransferCookieRetrieve.class.desiredAssertionStatus();
        if (Skript.methodExists(Player.class, (String)"retrieveCookie", (Class[])new Class[]{NamespacedKey.class})) {
            Skript.registerSection(SecTransferCookieRetrieve.class, (String[])new String[]{"retrieve cookie with key %namespacedkey/string% [from %player%]"});
        }
    }
}

