/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.sections.EffSecSpawn;
import ch.njol.skript.util.Direction;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.skript.base.EffectSection;
import com.shanebeestudios.skbee.api.util.Util;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.RegionAccessor;
import org.bukkit.Registry;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Minecraft - Spawn Entity")
@Description(value={"Spawn an entity from a Minecraft Key/EntityType.", "This is both a section and an effect (used just like Skript's spawn sec/effect). Requires Minecraft 1.20.2+"})
@Examples(value={"# Spawn from MinecraftEntityType", "mc spawn sheep at player", "mc spawn minecraft:cow at player", "mc spawn minecraft:wind_charge at player", "", "# Spawn from String", "mc spawn \"sheep\" at player", "mc spawn \"minecraft:cow\" at location(1,100,1)", "mc spawn \"minecraft:wind_charge\" above target block", "", "# Spawn from Minecraft Key", "set {_key} to mc key from \"minecraft:sheep\"", "mc spawn {_key} above target block", "mc spawn (mc key from \"sheep\") at {_location}", "mc spawn (minecraft key from \"minecraft:breeze\") at location(1,100,1, world \"world_nether\")", "", "# Spawn Using Section", "le spawn sheep at player:", "\tset ai of entity to false", "mc spawn minecraft:armor_stand at player:", "\tset gravity of entity to false", "mc spawn \"minecraft:breeze\" at player:", "\tset max health of entity to 100", "\tset health of entity to 100"})
@Since(value={"3.5.0"})
public class SecSpawnMinecraftEntity
extends EffectSection {
    private Expression<Number> amount;
    private Expression<?> entityType;
    private Expression<Location> location;
    private Trigger trigger;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, @Nullable SectionNode sectionNode, @Nullable List<TriggerItem> triggerItems) {
        this.amount = exprs[0];
        this.entityType = exprs[1];
        this.location = Direction.combine(exprs[2], exprs[3]);
        if (sectionNode != null) {
            AtomicBoolean delayed = new AtomicBoolean(false);
            Runnable afterLoading = () -> delayed.set(!this.getParser().getHasDelayBefore().isFalse());
            this.trigger = this.loadCode(sectionNode, "spawn", afterLoading, new Class[]{EffSecSpawn.SpawnEvent.class});
            if (delayed.get()) {
                Skript.error((String)"Delays can't be used within a Spawn Effect Section");
                return false;
            }
        }
        return true;
    }

    @Nullable
    protected TriggerItem walk(Event event) {
        Consumer<? extends Entity> consumer = this.getConsumer(event);
        Integer numberAmount = this.amount != null ? (Number)this.amount.getOptionalSingle(event).orElse(1) : (Number)1;
        double amount = ((Number)numberAmount).doubleValue();
        for (Location location : (Location[])this.location.getArray(event)) {
            World world = location.getWorld();
            if (world == null) continue;
            for (Object entityType : this.entityType.getArray(event)) {
                Class<? extends Entity> entityClass = this.getEntityClass(entityType);
                if (entityClass == null) continue;
                int i = 0;
                while ((double)i < amount) {
                    EffSecSpawn.lastSpawned = world.spawn(location, entityClass, consumer);
                    ++i;
                }
            }
        }
        return super.walk(event, false);
    }

    @Nullable
    private Consumer<? extends Entity> getConsumer(Event event) {
        Consumer<Entity> consumer = null;
        if (this.trigger != null) {
            consumer = entity -> {
                EffSecSpawn.SpawnEvent spawnEvent = new EffSecSpawn.SpawnEvent(entity);
                Variables.setLocalVariables((Event)spawnEvent, (Object)Variables.copyLocalVariables((Event)event));
                TriggerItem.walk((TriggerItem)this.trigger, (Event)spawnEvent);
                Variables.setLocalVariables((Event)event, (Object)Variables.copyLocalVariables((Event)spawnEvent));
                Variables.removeLocals((Event)spawnEvent);
            };
        }
        return consumer;
    }

    @Nullable
    private Class<? extends Entity> getEntityClass(Object object) {
        String string;
        NamespacedKey key;
        if (object instanceof EntityType) {
            EntityType et = (EntityType)object;
            return et.getEntityClass();
        }
        if (object instanceof NamespacedKey) {
            NamespacedKey key2 = (NamespacedKey)object;
            EntityType et = (EntityType)Registry.ENTITY_TYPE.get(key2);
            if (et != null) {
                return et.getEntityClass();
            }
        } else if (object instanceof String && (key = Util.getNamespacedKey(string = (String)object, false)) != null) {
            return this.getEntityClass(key);
        }
        this.error("Couldn't get entity from '" + Classes.toString((Object)object) + "'");
        return null;
    }

    @NotNull
    public String toString(Event e, boolean d) {
        String amount = this.amount != null ? String.valueOf(this.amount) + " of " : "";
        String type = this.entityType.toString(e, d);
        String loc = this.location.toString(e, d);
        return "minecraft spawn " + amount + type + loc;
    }

    static {
        if (Skript.methodExists(RegionAccessor.class, (String)"spawn", (Class[])new Class[]{Location.class, Class.class, Consumer.class})) {
            Skript.registerSection(SecSpawnMinecraftEntity.class, (String[])new String[]{"(minecraft|mc|skbee|le) spawn [%number% of] %minecraftentitytypes/namespacedkeys/strings% [%directions% %locations%]"});
        }
    }
}

