/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.skript.base.Section;
import com.shanebeestudios.skbee.api.util.EntityUtils;
import com.shanebeestudios.skbee.api.util.ItemUtils;
import com.shanebeestudios.skbee.api.util.SimpleEntryValidator;
import com.shanebeestudios.skbee.api.util.Util;
import java.util.List;
import java.util.UUID;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.entry.EntryContainer;
import org.skriptlang.skript.lang.entry.EntryValidator;

@Name(value="Attribute Modifier Apply")
@Description(value={"Apply an attribute modifier to an item or living entity.", "If running Minecraft 1.21+ use `id`", "If running Minecraft 1.20.6 and below, use `name` and `uuid` (uuid is optional, will default to random).", "See [**McWiki Component**](https://minecraft.wiki/w/Data_component_format#attribute_modifiers) and [**McWiki Modifiers**](https://minecraft.wiki/w/Attribute#Modifiers) for further details.", "", "`transient` = Non-persisent attribute modifier (LivingEntities only, not Items), will not save to the entity's NBT (Requires PaperMC).", "", "**Entries/Sections**:", "- `attribute` = The attribute this modifier is to act upon.", "- `slot` = Slot Type the item must be in for the modifier to take effect (Minecraft 1.20.6+ uses Equipment Slot Group, other versions use Equipment Slot).", "- `id` = The NamespacedKey to identify this modifier (Minecraft 1.21+).", "- `name` = The name used to identifiy this modifier (Minecraft 1.20.6 and below).", "- `uuid` = The uuid used to identify this modifier [optional] (Minecraft 1.20.6 and below).", "- `amount` = Amount of change from the modifier.", "- `operation` = The operation to decide how to modify. See [**McWiki**](https://minecraft.wiki/w/Attribute#Operations) for more details."})
@Examples(value={"#Apply Attribute Modifiers to Items", "set {_i} to a stick", "apply attribute modifier to {_i}:", "\tattribute: scale", "\tid: \"minecraft:my_hand_scale\"", "\tslot: mainhand_slot_group", "\tamount: 2", "\toperation: add_number", "apply attribute modifier to {_i}:", "\tattribute: scale", "\tid: \"minecraft:my_hand_scale_off\"", "\tslot: offhand_slot_group", "\tamount: -0.9", "\toperation: add_number", "give player 1 of {_i}", "#Apply Attribute Modifiers to LivingEntities", "apply transient attribute modifier to player:", "\tid: \"my_mods:mining\"", "\tattribute: player mining efficiency", "\tamount: 50", "\toperation: add_number", "apply transient attribute modifier to player:", "\tid: \"my_mods:scale\"", "\tattribute: scale", "\tamount: -0.5", "\toperation: add_number"})
@Since(value={"3.5.9"})
public class SecAttributeModifier
extends Section {
    private static final EntryValidator VALIDATOR;
    private boolean trans;
    private Expression<?> objects;
    private Expression<Attribute> attribute;
    private Expression<?> slot;
    private Expression<String> id;
    private Expression<String> name;
    private Expression<String> uuid;
    private Expression<Number> amount;
    private Expression<AttributeModifier.Operation> operation;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, SectionNode sectionNode, List<TriggerItem> triggerItems) {
        EntryContainer container = VALIDATOR.validate(sectionNode);
        if (container == null) {
            return false;
        }
        this.trans = parseResult.hasTag("transient");
        if (this.trans && !EntityUtils.HAS_TRANSIENT) {
            Skript.error((String)"'transient' requires a PaperMC server.");
            return false;
        }
        this.objects = exprs[0];
        this.attribute = (Expression)container.getOptional("attribute", false);
        this.slot = (Expression)container.getOptional("slot", false);
        if (ItemUtils.HAS_KEY) {
            this.id = (Expression)container.getOptional("id", false);
            if (this.id == null) {
                return false;
            }
        } else {
            this.name = (Expression)container.getOptional("name", false);
            this.uuid = (Expression)container.getOptional("uuid", false);
            if (this.name == null) {
                return false;
            }
        }
        this.amount = (Expression)container.getOptional("amount", false);
        this.operation = (Expression)container.getOptional("operation", false);
        return this.attribute != null && this.amount != null;
    }

    @Nullable
    protected TriggerItem walk(Event event) {
        AttributeModifier attributeModifier;
        Object slot;
        Attribute attribute = (Attribute)this.attribute.getSingle(event);
        Number amountNum = (Number)this.amount.getSingle(event);
        AttributeModifier.Operation operation = (AttributeModifier.Operation)this.operation.getSingle(event);
        Object object = slot = this.slot != null ? this.slot.getSingle(event) : null;
        if (attribute == null) {
            this.error("Attribute is missing");
            return super.walk(event, false);
        }
        if (amountNum == null) {
            this.error("Amount is missing");
            return super.walk(event, false);
        }
        if (operation == null) {
            this.error("Operation is missing");
            return super.walk(event, false);
        }
        if (ItemUtils.HAS_KEY) {
            EquipmentSlotGroup esg;
            String id = (String)this.id.getSingle(event);
            if (id == null) {
                this.error("Invalid id: " + this.id.toString(event, true));
                return super.walk(event, false);
            }
            NamespacedKey namespacedKey = Util.getNamespacedKey(id, false);
            if (namespacedKey == null) {
                this.error("Invalid id: " + id);
                return super.walk(event, false);
            }
            EquipmentSlotGroup slotGroup = slot instanceof EquipmentSlotGroup ? (esg = (EquipmentSlotGroup)slot) : EquipmentSlotGroup.ANY;
            attributeModifier = new AttributeModifier(namespacedKey, amountNum.doubleValue(), operation, slotGroup);
        } else {
            UUID uuid;
            String name = (String)this.name.getSingle(event);
            String uuidString = this.uuid != null ? (String)this.uuid.getSingle(event) : null;
            try {
                uuid = UUID.fromString(uuidString);
            }
            catch (IllegalArgumentException | NullPointerException ignore) {
                uuid = UUID.randomUUID();
            }
            if (name == null) {
                return super.walk(event, false);
            }
            if (slot instanceof EquipmentSlot) {
                EquipmentSlot equipmentSlot = (EquipmentSlot)slot;
                attributeModifier = new AttributeModifier(uuid, name, amountNum.doubleValue(), operation, equipmentSlot);
            } else if (ItemUtils.HAS_EQUIPMENT_SLOT_GROUP && slot instanceof EquipmentSlotGroup) {
                EquipmentSlotGroup slotGroup = (EquipmentSlotGroup)slot;
                attributeModifier = new AttributeModifier(uuid, name, amountNum.doubleValue(), operation, slotGroup);
            } else {
                attributeModifier = new AttributeModifier(uuid, name, amountNum.doubleValue(), operation);
            }
        }
        for (Object object2 : this.objects.getArray(event)) {
            LivingEntity entity;
            AttributeInstance attributeInstance;
            if (object2 instanceof ItemType) {
                ItemType itemType = (ItemType)object2;
                ItemMeta itemMeta = itemType.getItemMeta();
                if (!ItemUtils.hasAttributeModifier(itemMeta, attribute, attributeModifier)) {
                    itemMeta.addAttributeModifier(attribute, attributeModifier);
                }
                itemType.setItemMeta(itemMeta);
                continue;
            }
            if (!(object2 instanceof LivingEntity) || (attributeInstance = (entity = (LivingEntity)object2).getAttribute(attribute)) == null || EntityUtils.hasAttributeModifier(entity, attribute, attributeModifier)) continue;
            if (this.trans) {
                attributeInstance.addTransientModifier(attributeModifier);
                continue;
            }
            attributeInstance.addModifier(attributeModifier);
        }
        return super.walk(event, false);
    }

    @NotNull
    public String toString(Event e, boolean d) {
        String t = this.trans ? " transient " : " ";
        return "apply" + t + "attribute modifier to " + this.objects.toString(e, d);
    }

    static {
        SimpleEntryValidator builder = SimpleEntryValidator.builder();
        builder.addRequiredEntry("attribute", Attribute.class);
        if (ItemUtils.HAS_EQUIPMENT_SLOT_GROUP) {
            builder.addOptionalEntry("slot", EquipmentSlotGroup.class);
        } else {
            builder.addOptionalEntry("slot", EquipmentSlot.class);
        }
        if (ItemUtils.HAS_KEY) {
            builder.addRequiredEntry("id", String.class);
        } else {
            builder.addRequiredEntry("name", String.class);
            builder.addOptionalEntry("uuid", String.class);
        }
        builder.addRequiredEntry("amount", Number.class);
        builder.addRequiredEntry("operation", AttributeModifier.Operation.class);
        VALIDATOR = builder.build();
        Skript.registerSection(SecAttributeModifier.class, (String[])new String[]{"apply [:transient] attribute modifier to %itemtypes/livingentities%"});
    }
}

