/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Min/Max World Height")
@Description(value={"Get the min/max height of a world."})
@Examples(value={"set {_height} to max height of world of player"})
@Since(value={"2.14.0"})
public class ExprWorldHeight
extends SimplePropertyExpression<World, Number> {
    private boolean max;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.max = parseResult.hasTag("max");
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Nullable
    public Number convert(World world) {
        return this.max ? world.getMaxHeight() : world.getMinHeight();
    }

    @NotNull
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @NotNull
    protected String getPropertyName() {
        return (this.max ? "max" : "min") + " height";
    }

    static {
        ExprWorldHeight.register(ExprWorldHeight.class, Number.class, (String)"(min|:max) height", (String)"worlds");
    }
}

