/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="World AutoSave")
@Description(value={"Turn on/off world auto saving. This will prevent changes in the world to be saved to file.", "\nThis doesn't appear to work when the server stops, so you may need to manually unload your world."})
@Examples(value={"set world autosave of world of player to false"})
@Since(value={"2.10.0"})
public class ExprWorldAutoSave
extends SimplePropertyExpression<World, Boolean> {
    @Nullable
    public Boolean convert(World world) {
        return world.isAutoSave();
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Boolean.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        World[] worldArray;
        if (delta != null && (worldArray = delta[0]) instanceof Boolean) {
            Boolean bool = (Boolean)worldArray;
            if (mode == Changer.ChangeMode.SET) {
                for (World world : (World[])this.getExpr().getArray(event)) {
                    world.setAutoSave(bool.booleanValue());
                }
            }
        }
    }

    @NotNull
    public Class<? extends Boolean> getReturnType() {
        return Boolean.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "world auto save";
    }

    static {
        ExprWorldAutoSave.register(ExprWorldAutoSave.class, Boolean.class, (String)"world auto[ ]save", (String)"worlds");
    }
}

