/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Entity Ticking State")
@Description(value={"Represents whether or not an entity will tick.", "Currently this only works for ArmorStands and requies a PaperMC server."})
@Examples(value={"spawn an armor stand at player:", "\tset ticking state of entity to false"})
@Since(value={"2.13.0"})
public class ExprTickingState
extends SimplePropertyExpression<Entity, Boolean> {
    private static final boolean ARMOR_STAND_HAS_TICKING = Skript.methodExists(ArmorStand.class, (String)"canTick", (Class[])new Class[0]);

    @Nullable
    public Boolean convert(Entity entity) {
        if (entity instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)entity;
            if (ARMOR_STAND_HAS_TICKING) {
                return armorStand.canTick();
            }
        }
        return null;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Boolean.class});
        }
        return null;
    }

    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Entity[] entityArray;
        if (delta != null && (entityArray = delta[0]) instanceof Boolean) {
            Boolean canTick = (Boolean)entityArray;
            for (Entity entity : (Entity[])this.getExpr().getArray(e)) {
                if (!(entity instanceof ArmorStand)) continue;
                ArmorStand armorStand = (ArmorStand)entity;
                if (!ARMOR_STAND_HAS_TICKING) continue;
                armorStand.setCanTick(canTick.booleanValue());
            }
        }
    }

    @NotNull
    public Class<? extends Boolean> getReturnType() {
        return Boolean.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "ticking state";
    }

    static {
        ExprTickingState.register(ExprTickingState.class, Boolean.class, (String)"tick[ing] state", (String)"entities");
    }
}

