/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.EnchantmentType;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.ArrayList;
import java.util.Map;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

@Name(value="Stored Enchantments")
@Description(value={"Get/set the stored enchantments of an enchanted book."})
@Examples(value={"set {_a::*} to stored enchants of player's tool", "set stored enchants of player's tool to sharpness 3 and unbreaking 2", "add sharpness 1 to stored enchants of player's tool", "delete stored enchants of player's tool", "remove sharpness from stored enchants of player's tool"})
@Since(value={"1.0.0"})
public class ExprStoredEnchant
extends SimpleExpression<EnchantmentType> {
    private Expression<?> itemTypes;

    public boolean init(Expression<?>[] exprs, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.itemTypes = exprs[0];
        return true;
    }

    protected EnchantmentType[] get(Event event) {
        ArrayList<EnchantmentType> enchants = new ArrayList<EnchantmentType>();
        for (Object item : this.itemTypes.getAll(event)) {
            ItemMeta meta;
            ItemMeta itemMeta = meta = item instanceof ItemType ? ((ItemType)item).getItemMeta() : ((ItemStack)item).getItemMeta();
            if (!(meta instanceof EnchantmentStorageMeta)) continue;
            Map stored = ((EnchantmentStorageMeta)meta).getStoredEnchants();
            for (Enchantment ench : stored.keySet()) {
                enchants.add(new EnchantmentType(ench, ((Integer)stored.get(ench)).intValue()));
            }
        }
        return enchants.toArray(new EnchantmentType[0]);
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            case Changer.ChangeMode.SET, Changer.ChangeMode.ADD, Changer.ChangeMode.REMOVE, Changer.ChangeMode.DELETE -> (Class[])CollectionUtils.array((Object[])new Class[]{Enchantment[].class, EnchantmentType[].class});
            default -> null;
        };
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        EnchantmentType[] enchants = new EnchantmentType[delta != null ? delta.length : 0];
        if (delta != null && delta.length != 0) {
            for (int i = 0; i < delta.length; ++i) {
                enchants[i] = delta[i] instanceof EnchantmentType ? (EnchantmentType)delta[i] : new EnchantmentType((Enchantment)delta[i]);
            }
        }
        for (Object item : this.itemTypes.getAll(event)) {
            ItemType[] itemTypeArray;
            Object[] itemDelta;
            ItemMeta meta;
            ItemMeta itemMeta = meta = item instanceof ItemStack ? ((ItemStack)item).getItemMeta() : ((ItemType)item).getItemMeta();
            if (!(meta instanceof EnchantmentStorageMeta)) {
                return;
            }
            EnchantmentStorageMeta storageMeta = (EnchantmentStorageMeta)meta;
            switch (mode) {
                case SET: {
                    for (Enchantment ench : storageMeta.getStoredEnchants().keySet()) {
                        storageMeta.removeStoredEnchant(ench);
                    }
                }
                case ADD: {
                    for (EnchantmentType enchantmentType : enchants) {
                        if (enchantmentType.getType() == null) continue;
                        storageMeta.addStoredEnchant(enchantmentType.getType(), enchantmentType.getLevel(), true);
                    }
                    break;
                }
                case REMOVE: {
                    for (EnchantmentType enchantmentType : enchants) {
                        if (enchantmentType.getType() == null) continue;
                        storageMeta.removeStoredEnchant(enchantmentType.getType());
                    }
                    break;
                }
                case DELETE: {
                    for (Enchantment ench : storageMeta.getStoredEnchants().keySet()) {
                        storageMeta.removeStoredEnchant(ench);
                    }
                    break;
                }
                default: {
                    return;
                }
            }
            if (item instanceof ItemStack) {
                ((ItemStack)item).setItemMeta((ItemMeta)storageMeta);
            } else {
                ((ItemType)item).setItemMeta((ItemMeta)storageMeta);
            }
            if (Changer.ChangerUtils.acceptsChange(this.itemTypes, (Changer.ChangeMode)Changer.ChangeMode.SET, (Class[])new Class[]{item.getClass()})) {
                Object[] objectArray;
                if (item instanceof ItemStack) {
                    Object[] objectArray2 = new ItemStack[1];
                    objectArray = objectArray2;
                    objectArray2[0] = (ItemStack)item;
                } else {
                    ItemType[] itemTypeArray2 = new ItemType[1];
                    objectArray = itemTypeArray2;
                    itemTypeArray2[0] = (ItemType)item;
                }
                itemDelta = objectArray;
                this.itemTypes.change(event, itemDelta, Changer.ChangeMode.SET);
                continue;
            }
            if (item instanceof ItemStack) {
                ItemType[] itemTypeArray3 = new ItemType[1];
                itemTypeArray = itemTypeArray3;
                itemTypeArray3[0] = new ItemType((ItemStack)item);
            } else {
                ItemStack[] itemStackArray = new ItemStack[1];
                itemTypeArray = itemStackArray;
                itemStackArray[0] = ((ItemType)item).getRandom();
            }
            itemDelta = itemTypeArray;
            this.itemTypes.change(event, itemDelta, Changer.ChangeMode.SET);
        }
    }

    public boolean isSingle() {
        return false;
    }

    @NotNull
    public Class<? extends EnchantmentType> getReturnType() {
        return EnchantmentType.class;
    }

    @NotNull
    public String toString(Event e, boolean d) {
        return "stored enchantments of " + this.itemTypes.toString(e, d);
    }

    static {
        PropertyExpression.register(ExprStoredEnchant.class, EnchantmentType.class, (String)"stored enchant[ment]s", (String)"itemstacks/itemtypes");
    }
}

