/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Spawner - Spawn Count")
@Description(value={"Get how many mobs attempt to spawn. Default is 4."})
@Examples(value={"on place of mob spawner:", "\tset spawner spawn count of event-block to 10", "\tadd 10 to spawn count of event-block", "\treset spawn count of event-block"})
@Since(value={"2.16.0"})
public class ExprSpawnerSpawnCount
extends SimplePropertyExpression<Block, Integer> {
    private static final int DEFAULT_SPAWN_COUNT = 4;

    @Nullable
    public Integer convert(Block block) {
        BlockState blockState = block.getState();
        if (blockState instanceof CreatureSpawner) {
            CreatureSpawner spawner = (CreatureSpawner)blockState;
            return spawner.getSpawnCount();
        }
        return null;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            case Changer.ChangeMode.ADD, Changer.ChangeMode.SET, Changer.ChangeMode.REMOVE -> (Class[])CollectionUtils.array((Object[])new Class[]{Integer.class});
            case Changer.ChangeMode.RESET -> (Class[])CollectionUtils.array((Object[])new Class[0]);
            default -> null;
        };
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        int changeValue = delta == null ? 4 : (Integer)delta[0];
        switch (mode) {
            case SET: 
            case RESET: {
                for (Block block : (Block[])this.getExpr().getArray(event)) {
                    BlockState blockState = block.getState();
                    if (!(blockState instanceof CreatureSpawner)) continue;
                    CreatureSpawner spawner = (CreatureSpawner)blockState;
                    spawner.setSpawnCount(Math.max(changeValue, 0));
                    spawner.update();
                }
                break;
            }
            case REMOVE: {
                changeValue = -changeValue;
            }
            case ADD: {
                for (Block block : (Block[])this.getExpr().getArray(event)) {
                    BlockState blockState = block.getState();
                    if (!(blockState instanceof CreatureSpawner)) continue;
                    CreatureSpawner spawner = (CreatureSpawner)blockState;
                    int value = spawner.getSpawnCount() + changeValue;
                    spawner.setSpawnCount(Math.max(value, 0));
                    spawner.update();
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    protected String getPropertyName() {
        return "spawner spawn count";
    }

    static {
        ExprSpawnerSpawnCount.register(ExprSpawnerSpawnCount.class, Integer.class, (String)"[spawner] spawn count", (String)"blocks");
    }
}

