/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Entity Shoot Bow - Shot Bow")
@Description(value={"Gets the bow Item used to fire the arrow in an entity shoot bow event."})
@Examples(value={"on entity shoot bow:", "\tif name of shot bow != \"Mr Bow\":", "\t\tcancel event"})
@Since(value={"2.16.0"})
public class ExprShootBowShotBow
extends SimpleExpression<ItemType> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!ParserInstance.get().isCurrentEvent(EntityShootBowEvent.class)) {
            Skript.error((String)("'" + parseResult.expr + "' can only be used in the entity shoot bow event."));
            return false;
        }
        return true;
    }

    @Nullable
    protected ItemType[] get(Event event) {
        EntityShootBowEvent shootBowEvent;
        ItemStack bow;
        if (event instanceof EntityShootBowEvent && (bow = (shootBowEvent = (EntityShootBowEvent)event).getBow()) != null) {
            return new ItemType[]{new ItemType(bow)};
        }
        return null;
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "shot bow";
    }

    static {
        Skript.registerExpression(ExprShootBowShotBow.class, ItemType.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"shot bow"});
    }
}

