/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Entity Shoot Bow - Projectile")
@Description(value={"Get/set the projectile which will be launched in an entity shoot bow event.", "\nNOTE: Setting doesn't appear to do anything, server bug I guess?!?!"})
@Examples(value={"on entity shoot bow:", "\tmake player ride projectile entity"})
@Since(value={"2.16.0"})
public class ExprShootBowProjectile
extends SimpleExpression<Entity> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!ParserInstance.get().isCurrentEvent(EntityShootBowEvent.class)) {
            Skript.error((String)("'" + parseResult.expr + "' can only be used in the entity shoot bow event."));
            return false;
        }
        return true;
    }

    @Nullable
    protected Entity[] get(Event event) {
        if (event instanceof EntityShootBowEvent) {
            EntityShootBowEvent shootBowEvent = (EntityShootBowEvent)event;
            return new Entity[]{shootBowEvent.getProjectile()};
        }
        return null;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Entity.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Object object;
        if (!(event instanceof EntityShootBowEvent)) {
            return;
        }
        EntityShootBowEvent shootBowEvent = (EntityShootBowEvent)event;
        if (mode != Changer.ChangeMode.SET) {
            return;
        }
        if (delta != null && (object = delta[0]) instanceof Entity) {
            Entity projectile = (Entity)object;
            shootBowEvent.setProjectile(projectile);
        }
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Entity> getReturnType() {
        return Entity.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "projectile entity";
    }

    static {
        Skript.registerExpression(ExprShootBowProjectile.class, Entity.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"projectile entity"});
    }
}

