/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.skript.base.SimplePropertyExpression;
import com.shanebeestudios.skbee.api.util.ItemComponentUtils;
import com.shanebeestudios.skbee.api.util.ItemUtils;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.Nullable;

@Name(value="PotionType of Item")
@Description(value={"Get/set/delete the potion type of an item.", "This is not the same as the potion effect type, this is the base potion Minecraft uses for the potion items in the creative menu."})
@Examples(value={"set potion type of player's tool to strong_leaping", "if potion type of player's tool = strong leaping:", "delete potion type of player's tool"})
@Since(value={"3.8.1"})
public class ExprPotionTypeItem
extends SimplePropertyExpression<Object, PotionType> {
    private static final boolean HAS_COMPONENTS = Skript.classExists((String)"io.papermc.paper.datacomponent.DataComponentType");

    @Nullable
    public PotionType convert(Object from) {
        ItemStack itemStack = ItemUtils.getItemStackFromObjects(from);
        if (itemStack == null) {
            return null;
        }
        if (HAS_COMPONENTS) {
            return ItemComponentUtils.getPotionType(itemStack);
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)itemMeta;
            return potionMeta.getBasePotionType();
        }
        return null;
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{PotionType.class});
        }
        if (mode == Changer.ChangeMode.DELETE) {
            return (Class[])CollectionUtils.array((Object[])new Class[0]);
        }
        return null;
    }

    @Override
    public void change(Object from, Object @Nullable [] delta, Changer.ChangeMode mode) {
        PotionType pt;
        Object object;
        PotionType potionType = delta != null && (object = delta[0]) instanceof PotionType ? (pt = (PotionType)object) : null;
        ItemUtils.modifyItems(from, itemStack -> {
            if (HAS_COMPONENTS) {
                ItemComponentUtils.setPotionType(itemStack, potionType);
            } else {
                ItemMeta patt0$temp = itemStack.getItemMeta();
                if (patt0$temp instanceof PotionMeta) {
                    PotionMeta meta = (PotionMeta)patt0$temp;
                    meta.setBasePotionType(potionType);
                    itemStack.setItemMeta((ItemMeta)meta);
                }
            }
        });
    }

    protected String getPropertyName() {
        return "potion type";
    }

    public Class<? extends PotionType> getReturnType() {
        return PotionType.class;
    }

    static {
        ExprPotionTypeItem.register(ExprPotionTypeItem.class, PotionType.class, (String)"potion type", (String)"itemstacks/itemtypes/slots");
    }
}

