/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.Timespan;
import org.bukkit.potion.PotionEffect;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Potion Effect Duration")
@Description(value={"Get the duration of a potion effect. If running 1.19.4+ and the potion is infinite,", "it will return as the max available time."})
@Examples(value={"set {_duration::*} to potion duration of active potion effects of player"})
@Since(value={"2.8.5"})
public class ExprPotionEffectDuration
extends SimplePropertyExpression<PotionEffect, Timespan> {
    @Nullable
    public Timespan convert(PotionEffect potionEffect) {
        int duration = potionEffect.getDuration();
        duration = duration < 0 ? Integer.MAX_VALUE : duration;
        return new Timespan(Timespan.TimePeriod.TICK, (long)duration);
    }

    @NotNull
    public Class<? extends Timespan> getReturnType() {
        return Timespan.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "potion effect duration";
    }

    static {
        ExprPotionEffectDuration.register(ExprPotionEffectDuration.class, Timespan.class, (String)"potion [effect] duration[s]", (String)"potioneffects");
    }
}

