/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.util.EntityUtils;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Entity NoClip")
@Description(value={"Set or get the noClip status of an entity (This will not work on players)"})
@Examples(value={"spawn a zombie at player", "set no clip state of last spawned zombie to true", "set {_var} to no clip state of last spawned sheep", "loop all entities in radius 5 around player:", "\tset no clip state of loop-entity to true", "\tpush loop-entity up with speed 5"})
@Since(value={"1.0.2"})
public class ExprNoClip
extends SimplePropertyExpression<Entity, Boolean> {
    @Nullable
    public Boolean convert(Entity entity) {
        return EntityUtils.getNoPhysics(entity);
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Boolean.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Boolean changeValue = (Boolean)delta[0];
        if (changeValue == null) {
            return;
        }
        if (mode == Changer.ChangeMode.SET) {
            for (Entity entity : (Entity[])this.getExpr().getArray(event)) {
                EntityUtils.setNoPhysics(entity, changeValue);
            }
        }
    }

    @NotNull
    public Class<? extends Boolean> getReturnType() {
        return Boolean.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "no clip state";
    }

    static {
        PropertyExpression.register(ExprNoClip.class, Boolean.class, (String)"no[( |-)](clip|physics) (state|mode)", (String)"entities");
    }
}

