/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.skript.base.SimpleExpression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Nearest Entity")
@Description(value={"Returns the nearest entity around a location/entity. Requires PaperMC.", "\nNOTE: When using `around entity`, this will exclude that entity in the search.", "\nNOTE: When radius is excluded, the distance will default to Skript's `maximum target block distance`."})
@Examples(value={"kill nearest player in radius 10 around player", "damage nearest mob in radius 5 around player", "set {_near} to nearest entity in radius 50 around {_loc}", "set {_near} to nearest entity in radius 100 around location(100,100,100,world \"world\")", "teleport player to nearest player in radius 10 around player", "damage 10 nearest entity in radius 10 around player by 2", "set {_p} to nearest player around player excluding (all player's where [input doesn't have permission \"some.perm\"])"})
@Since(value={"2.7.2"})
public class ExprNearestEntity
extends SimpleExpression<Entity> {
    private static final int MAX_TARGET_BLOCK_DISTANCE = (Integer)SkriptConfig.maxTargetBlockDistance.value();
    private Expression<Number> number;
    private Expression<EntityData<?>> entityData;
    private Expression<Number> radius;
    private Expression<Object> location;
    private Expression<Entity> excluding;
    private boolean isSingle;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.number = exprs[0];
        this.entityData = exprs[1];
        this.radius = exprs[2];
        this.location = exprs[3];
        this.excluding = exprs[4];
        this.isSingle = !parseResult.hasTag("num");
        return true;
    }

    protected Entity @Nullable [] get(Event event) {
        List<Entity> nearby;
        Number number = (Number)this.number.getSingle(event);
        EntityData entityData = (EntityData)this.entityData.getSingle(event);
        Integer radius = this.radius != null ? (Number)((Number)this.radius.getSingle(event)) : (Number)MAX_TARGET_BLOCK_DISTANCE;
        Object object = this.location.getSingle(event);
        if (number == null || entityData == null || radius == null || object == null) {
            return null;
        }
        double rad = ((Number)radius).doubleValue();
        ArrayList<Entity> excluding = new ArrayList();
        if (this.excluding != null) {
            excluding = Arrays.asList((Entity[])this.excluding.getArray(event));
        }
        if (object instanceof Entity) {
            Entity entity = (Entity)object;
            nearby = this.getNearby(entity.getLocation(), entityData, rad, entity, excluding);
        } else {
            nearby = this.getNearby((Location)object, entityData, rad, null, excluding);
        }
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (int i = 0; i < number.intValue(); ++i) {
            if (i >= nearby.size()) continue;
            entities.add(nearby.get(i));
        }
        return entities.toArray(new Entity[0]);
    }

    private List<Entity> getNearby(Location location, EntityData<?> entityData, double radius, Object self, List<Entity> excluding) {
        World world = location.getWorld();
        return world.getNearbyEntitiesByType(entityData.getType(), location, radius).stream().sorted(Comparator.comparing(entity -> entity.getLocation().distanceSquared(location))).filter(entity -> entity != self).filter(entity -> !excluding.contains(entity)).collect(Collectors.toList());
    }

    public boolean isSingle() {
        return this.isSingle;
    }

    @NotNull
    public Class<? extends Entity> getReturnType() {
        return Entity.class;
    }

    @NotNull
    public String toString(Event e, boolean d) {
        String num = this.number != null ? this.number.toString(e, d) + " " : "";
        String data = this.entityData.toString(e, d);
        String radius = this.radius.toString(e, d);
        String loc = this.location.toString(e, d);
        String excluding = this.excluding != null ? " excluding " + this.excluding.toString(e, d) : "";
        return num + "nearest " + data + " in radius " + radius + " around " + loc + excluding;
    }

    static {
        if (Skript.methodExists(World.class, (String)"getNearbyEntitiesByType", (Class[])new Class[]{Class.class, Location.class, Double.TYPE})) {
            Skript.registerExpression(ExprNearestEntity.class, Entity.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[num:%number%] nearest %entitydata% [in radius %-number%] (at|of|around) %location/entity% [excluding %-entities%]"});
        }
    }
}

