/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.ArrayList;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.event.Event;
import org.bukkit.loot.LootTable;
import org.bukkit.loot.Lootable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="LootTable - LootTable of Lootable")
@Description(value={"Get/set/delete the LootTable of a lootable object such as a block or entity.", "`with seed` = Provide an optional seed for loot generation otherwise will randomly generate."})
@Examples(value={"set {_lootTable} to loottable of target block", "set loottable of target block to loottable from key \"minecraft:chests/ancient_city\""})
@Since(value={"3.4.0"})
public class ExprLootTableObject
extends SimpleExpression<LootTable> {
    private Expression<?> objects;
    private Expression<Number> seed;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.objects = exprs[0];
        this.seed = exprs[1];
        return true;
    }

    @Nullable
    protected LootTable[] get(Event event) {
        ArrayList<LootTable> tables = new ArrayList<LootTable>();
        for (Object object : this.objects.getArray(event)) {
            Block block;
            BlockState blockState;
            if (object instanceof Lootable) {
                Lootable lootable = (Lootable)object;
                tables.add(lootable.getLootTable());
                continue;
            }
            if (!(object instanceof Block) || !((blockState = (block = (Block)object).getState()) instanceof Lootable)) continue;
            Lootable lootable = (Lootable)blockState;
            tables.add(lootable.getLootTable());
        }
        return tables.toArray(new LootTable[0]);
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{LootTable.class});
        }
        if (mode == Changer.ChangeMode.DELETE) {
            return (Class[])CollectionUtils.array((Object[])new Class[0]);
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        LootTable table;
        Object[] objectArray;
        LootTable lootTable = delta != null && (objectArray = delta[0]) instanceof LootTable ? (table = (LootTable)objectArray) : null;
        Number seed = this.seed != null ? (Number)((Number)this.seed.getSingle(event)) : (Number)null;
        for (Object object : this.objects.getArray(event)) {
            Block block;
            BlockState state;
            if (object instanceof Lootable) {
                Lootable lootable = (Lootable)object;
                ExprLootTableObject.setLootTable(lootable, lootTable, seed);
                continue;
            }
            if (!(object instanceof Block) || !((state = (block = (Block)object).getState()) instanceof Lootable)) continue;
            Lootable lootable = (Lootable)state;
            ExprLootTableObject.setLootTable(lootable, lootTable, seed);
            state.update(true);
        }
    }

    private static void setLootTable(@NotNull Lootable lootable, @Nullable LootTable lootTable, @Nullable Number seed) {
        if (lootTable == null) {
            lootable.clearLootTable();
        } else if (seed == null) {
            lootable.setLootTable(lootTable);
        } else {
            lootable.setLootTable(lootTable, seed.longValue());
        }
    }

    public boolean isSingle() {
        return this.objects.isSingle();
    }

    @NotNull
    public Class<? extends LootTable> getReturnType() {
        return LootTable.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String seed = this.seed != null ? " with seed " + this.seed.toString(e, d) : "";
        return "loot table of " + this.objects.toString(e, d) + seed;
    }

    static {
        Skript.registerExpression(ExprLootTableObject.class, LootTable.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"loot[ ]table of %blocks/entities% [with seed %-number%]"});
    }
}

