/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.util.Util;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Lockable;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Key of Block")
@Description(value={"Get or set the lock of a container or beacon.", "Removed in Minecraft 1.21.2.", "See 'Apply Lock to Block' effect to apply an item as a lock to a block."})
@Examples(value={"on right click on shulker box or beacon:", "\tclicked block is locked", "\tplayer has permission \"see.locked\"", "\tsend action bar \"%container key of clicked block%\" to player"})
@Since(value={"2.16.0"})
public class ExprLockableKey
extends SimplePropertyExpression<Block, String> {
    private static final boolean INVALID = Util.IS_RUNNING_MC_1_21_2;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (INVALID) {
            Skript.warning((String)"String based container locks have been removed in Minecraft 1.21.2.");
        }
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Nullable
    public String convert(Block block) {
        BlockState blockState = block.getState();
        if (blockState instanceof Lockable) {
            Lockable container = (Lockable)blockState;
            return container.isLocked() ? container.getLock() : null;
        }
        return null;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            case Changer.ChangeMode.SET -> (Class[])CollectionUtils.array((Object[])new Class[]{String.class});
            case Changer.ChangeMode.RESET -> (Class[])CollectionUtils.array((Object[])new Class[0]);
            default -> null;
        };
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        String lock;
        String string = lock = delta == null ? null : (String)delta[0];
        if (lock != null && lock.isBlank()) {
            lock = null;
        }
        switch (mode) {
            case SET: 
            case RESET: {
                for (Block block : (Block[])this.getExpr().getArray(event)) {
                    BlockState state = block.getState();
                    if (!(state instanceof Lockable)) continue;
                    Lockable lockable = (Lockable)state;
                    lockable.setLock(lock);
                    state.update();
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    protected String getPropertyName() {
        return "container key";
    }

    static {
        ExprLockableKey.register(ExprLockableKey.class, String.class, (String)"(container|lockable) key", (String)"blocks");
    }
}

