/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Block - Exact Location")
@Description(value={"Returns the EXACT location of a block.", "Skript's `location of block` adds 0.5 to each x,y,z coord of the location, the \"center\" of the block.", "This expression will return the true location of a block."})
@Examples(value={"set {_loc} to exact location of event-block", "set {_loc} to exact location of target block", "if y coord of exact location of event-block = 5:"})
@Since(value={"2.5.1"})
public class ExprExactBlockLocation
extends SimplePropertyExpression<Block, Location> {
    @Nullable
    public Location convert(Block block) {
        return block.getLocation();
    }

    @NotNull
    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "exact location";
    }

    static {
        ExprExactBlockLocation.register(ExprExactBlockLocation.class, Location.class, (String)"(exact|true) location", (String)"blocks");
    }
}

