/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Pose;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Entity Pose")
@Description(value={"Get/set the pose of an entity.", "Note: While poses affect some things like hitboxes, they do not change the entity's state", "(e.g. having sneaking pose does not guarantee `is sneaking` being true). Set requires PaperMC."})
@Examples(value={"set {_pose} to pose of player", "set pose of target entity to sleeping pose"})
@Since(value={"3.5.4"})
public class ExprEntityPose
extends SimplePropertyExpression<Entity, Pose> {
    @Nullable
    public Pose convert(Entity entity) {
        return entity.getPose();
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (!Skript.methodExists(Entity.class, (String)"setPose", (Class[])new Class[]{Pose.class})) {
            Skript.error((String)"Setting an entity's pose requires PaperMC.");
            return null;
        }
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Pose.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Entity[] entityArray;
        if (delta != null && (entityArray = delta[0]) instanceof Pose) {
            Pose pose = (Pose)entityArray;
            for (Entity entity : (Entity[])this.getExpr().getArray(event)) {
                entity.setPose(pose);
            }
        }
    }

    @NotNull
    public Class<? extends Pose> getReturnType() {
        return Pose.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "pose";
    }

    static {
        ExprEntityPose.register(ExprEntityPose.class, Pose.class, (String)"pose", (String)"entities");
    }
}

