/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.EnchantmentType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Enchantment Level")
@Description(value={"Get the enchantment level from an Enchantment Type."})
@Examples(value={"loop enchantments of player's tool:", "\tset {_level} to enchantment level of loop-value", "\tset {_enchant} to enchantment of loop-value"})
@Since(value={"1.16.0"})
public class ExprEnchantmentLevel
extends SimplePropertyExpression<EnchantmentType, Number> {
    @Nullable
    public Number convert(EnchantmentType enchantmentType) {
        return enchantmentType.getLevel();
    }

    @NotNull
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "enchantment level";
    }

    static {
        ExprEnchantmentLevel.register(ExprEnchantmentLevel.class, Number.class, (String)"enchantment level", (String)"enchantmenttypes");
    }
}

