/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.util.Kleenean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Skript Type of Object")
@Description(value={"Returns the Skript type (also known as 'ClassInfo') of an object.", "Useful for debugging. Will return as a string."})
@Examples(value={"set {_info} to class info of player's tool"})
@Since(value={"2.5.2"})
public class ExprClassInfoOf
extends SimplePropertyExpression<Object, String> {
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        Expression objectExpression = LiteralUtils.defendExpression(exprs[0]);
        this.setExpr(objectExpression);
        return LiteralUtils.canInitSafely((Expression[])new Expression[]{objectExpression});
    }

    @Nullable
    public String convert(Object o) {
        ClassInfo superClassInfo = Classes.getSuperClassInfo(o.getClass());
        return superClassInfo.toString();
    }

    @NotNull
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "class info";
    }

    static {
        ExprClassInfoOf.register(ExprClassInfoOf.class, String.class, (String)"(class[ ]info|skript[ ]type)", (String)"objects");
    }
}

