/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.skript.base.SimpleExpression;
import java.util.ArrayList;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Chunks Within Locations")
@Description(value={"Get a list of all chunks within 2 locations."})
@Examples(value={"loop all chunks within {_l1} and {_l2}:", "refresh all chunks within {_l1} and {_l2}"})
@Since(value={"3.6.1"})
public class ExprChunksWithinCuboid
extends SimpleExpression<Chunk> {
    private Expression<Location> loc1;
    private Expression<Location> loc2;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.loc1 = exprs[0];
        this.loc2 = exprs[1];
        return true;
    }

    protected Chunk @Nullable [] get(Event event) {
        Location loc1 = (Location)this.loc1.getSingle(event);
        Location loc2 = (Location)this.loc2.getSingle(event);
        if (loc1 == null || loc2 == null) {
            return null;
        }
        World world = loc1.getWorld();
        if (world != loc2.getWorld()) {
            String w1 = loc1.getWorld().getName();
            String w2 = loc2.getWorld().getName();
            this.error("Both locations have to be in the same world but got " + w1 + " and " + w2);
            return null;
        }
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        int minX = Math.min(loc1.getBlockX(), loc2.getBlockX()) >> 4;
        int minZ = Math.min(loc1.getBlockZ(), loc2.getBlockZ()) >> 4;
        int maxX = Math.max(loc1.getBlockX(), loc2.getBlockX()) + 1 >> 4;
        int maxZ = Math.max(loc1.getBlockZ(), loc2.getBlockZ()) + 1 >> 4;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                chunks.add(world.getChunkAt(x, z, false));
            }
        }
        return chunks.toArray(new Chunk[0]);
    }

    public boolean isSingle() {
        return false;
    }

    @NotNull
    public Class<? extends Chunk> getReturnType() {
        return Chunk.class;
    }

    @NotNull
    public String toString(Event e, boolean d) {
        return "all chunks within " + this.loc1.toString(e, d) + " and " + this.loc2.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprChunksWithinCuboid.class, Chunk.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"all chunks within %location% and %location%"});
    }
}

