/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import org.bukkit.block.BlockState;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;

@Name(value="BlockState - Offset")
@Description(value={"Represents the offset of a blockstate in a structure.", "This is a vector, distance from the starting block of a structure."})
@Examples(value={"set {_offset} to blockstate offset of {_blockstate}"})
@Since(value={"2.13.0"})
public class ExprBlockStateOffset
extends SimpleExpression<Vector> {
    private Expression<BlockState> blockstate;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.blockstate = exprs[0];
        return true;
    }

    @Nullable
    protected Vector[] get(Event event) {
        ArrayList<Vector> offsets = new ArrayList<Vector>();
        for (BlockState blockState : (BlockState[])this.blockstate.getAll(event)) {
            offsets.add(blockState.getLocation().toVector());
        }
        return offsets.toArray(new Vector[0]);
    }

    public boolean isSingle() {
        return this.blockstate.isSingle();
    }

    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    public String toString(@Nullable Event e, boolean d) {
        return "blockstate offset of " + this.blockstate.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprBlockStateOffset.class, Vector.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"block[ ]state offset[s] of %blockstates%"});
    }
}

