/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.block.BlockState;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="BlockState - ItemType")
@Description(value={"Represents the itemtype of a block state."})
@Examples(value={"set {_type} to blockstate itemtype of {_blockstate}", "set blockstate itemtype of {_blockstate} to stone"})
@Since(value={"2.13.0"})
public class ExprBlockStateItemType
extends SimplePropertyExpression<BlockState, ItemType> {
    @Nullable
    public ItemType convert(BlockState blockState) {
        return new ItemType(blockState.getType());
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{ItemType.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        BlockState[] blockStateArray;
        if (delta != null && (blockStateArray = delta[0]) instanceof ItemType) {
            ItemType itemType = (ItemType)blockStateArray;
            for (BlockState blockState : (BlockState[])this.getExpr().getArray(event)) {
                blockState.setType(itemType.getMaterial());
            }
        }
    }

    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "blockstate itemtype";
    }

    static {
        Skript.registerExpression(ExprBlockStateItemType.class, ItemType.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"block[ ]state [item[ ]]type of %blockstates%"});
    }
}

