/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="BlockState - BlockData")
@Description(value={"Represents the blockdata of a block state."})
@Examples(value={"set {_data} to blockstate blockdata of {_blockstate}", "set blockstate blockdata of {_blockstate} to stone[]"})
@Since(value={"2.13.0"})
public class ExprBlockStateBlockData
extends SimplePropertyExpression<BlockState, BlockData> {
    @Nullable
    public BlockData convert(BlockState blockState) {
        return blockState.getBlockData();
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{BlockData.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        BlockState[] blockStateArray;
        if (delta != null && (blockStateArray = delta[0]) instanceof BlockData) {
            BlockData blockData = (BlockData)blockStateArray;
            for (BlockState blockState : (BlockState[])this.getExpr().getArray(event)) {
                blockState.setBlockData(blockData);
            }
        }
    }

    public Class<? extends BlockData> getReturnType() {
        return BlockData.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "blockstate blockdate";
    }

    static {
        ExprBlockStateBlockData.register(ExprBlockStateBlockData.class, BlockData.class, (String)"block[ ]state block[ ]data[s]", (String)"blockstates");
    }
}

