/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.api.util.Util;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="BlockData - Updates")
@Description(value={"Set the BlockData of a block without updates (will prevent physics updates of neighbouring blocks)."})
@Examples(value={"set blockdata of target block without updates to oak_fence[]", "set blockdata of target block without updates to campfire[lit=false]"})
@Since(value={"2.6.0"})
public class ExprBlockDataUpdates
extends SimpleExpression<BlockData> {
    private Expression<Block> blocks;

    public boolean init(Expression<?>[] exprs, int i, @NotNull Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.blocks = exprs[0];
        return true;
    }

    protected BlockData @NotNull [] get(@NotNull Event event) {
        ArrayList<BlockData> list = new ArrayList<BlockData>();
        for (Block block : (Block[])this.blocks.getAll(event)) {
            list.add(block.getBlockData());
        }
        return list.toArray(new BlockData[0]);
    }

    public Class<?>[] acceptChange(@NotNull Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{BlockData.class});
        }
        return null;
    }

    public void change(@NotNull Event e, Object[] delta, @NotNull Changer.ChangeMode mode) {
        for (Block block : (Block[])this.blocks.getAll(e)) {
            try {
                BlockData blockData;
                if (delta == null) continue;
                Object object = delta[0];
                if (object instanceof BlockData) {
                    BlockData bd;
                    blockData = bd = (BlockData)object;
                } else if (object instanceof String) {
                    String string = (String)object;
                    blockData = Bukkit.createBlockData((String)string);
                } else if (object instanceof ItemType) {
                    ItemType itemType = (ItemType)object;
                    blockData = itemType.getMaterial().createBlockData();
                } else {
                    return;
                }
                block.setBlockData(blockData, false);
            }
            catch (IllegalArgumentException ex) {
                Util.debug("Could not parse block data: %s", delta[0]);
            }
        }
    }

    @NotNull
    public Class<? extends BlockData> getReturnType() {
        return BlockData.class;
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public String toString(Event e, boolean d) {
        return "block data of " + this.blocks.toString(e, d) + " without updates";
    }

    static {
        Skript.registerExpression(ExprBlockDataUpdates.class, BlockData.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"block[ ](data|state) of %blocks% without update[s]"});
    }
}

