/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.util.BlockDataUtils;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="BlockData - Tags")
@Description(value={"Get a list of all block data tags of a Block or BlockData."})
@Examples(value={"set {_data::*} to block data tags of target block of player", "loop block data tags of target block of player:"})
@Since(value={"1.0.0, 2.16.1 (BlockData Support)"})
public class ExprBlockDataTags
extends SimpleExpression<String> {
    private Expression<?> objects;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.objects = exprs[0];
        return true;
    }

    protected String @NotNull [] get(@NotNull Event event) {
        ArrayList<String> list = new ArrayList<String>();
        for (Object object : this.objects.getAll(event)) {
            BlockData blockData;
            if (object instanceof Block) {
                Block block = (Block)object;
                blockData = block.getBlockData();
            } else {
                BlockData bd;
                if (!(object instanceof BlockData)) continue;
                blockData = bd = (BlockData)object;
            }
            String[] tags = BlockDataUtils.getBlockDataTags(blockData);
            if (tags == null) continue;
            list.addAll(Arrays.asList(tags));
        }
        return list.toArray(new String[0]);
    }

    @NotNull
    public Class<String> getReturnType() {
        return String.class;
    }

    public boolean isSingle() {
        return false;
    }

    @NotNull
    public String toString(Event e, boolean d) {
        return "block data tags of " + this.objects.toString(e, d);
    }

    static {
        Skript.registerExpression(ExprBlockDataTags.class, String.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"block[ ](data|state) tags of %blocks/blockdatas%"});
    }
}

