/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.RegionAccessor;
import org.bukkit.UnsafeValues;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Biome Key of Location")
@Description(value={"Get/set the biome of a block/location using a NamespacedKey. Requires Paper 1.19+.", "**NOTES**:", "- This will support custom biomes.", "- When setting this will not immediately visually update the biome to players, you will need to use the `refresh %chunk%` effect."})
@Examples(value={"set biome key of block at player to mc key \"minecraft:plains\"", "set biome key of blocks in chunk at player to mc key \"wythers:ancient_taiga\"", "refresh chunk at player # forces biomes to be re-sent to the player.", "set {_key} to biome key of block at player", "set {_keys::*} to biome keys of blocks in chunk at player"})
@Since(value={"3.6.0"})
public class ExprBiomeKeyLocation
extends SimplePropertyExpression<Location, NamespacedKey> {
    private static final UnsafeValues UNSAFE = Bukkit.getUnsafe();

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (Biome.class.isInterface()) {
            Skript.warning((String)"Deprecated, you can just set the biome now.");
        }
        return super.init(expressions, matchedPattern, isDelayed, parseResult);
    }

    @Nullable
    public NamespacedKey convert(Location from) {
        World world = from.getWorld();
        if (world != null) {
            return UNSAFE.getBiomeKey((RegionAccessor)world, from.getBlockX(), from.getBlockY(), from.getBlockZ());
        }
        return null;
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{NamespacedKey.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Location[] locationArray;
        if (delta != null && (locationArray = delta[0]) instanceof NamespacedKey) {
            NamespacedKey key = (NamespacedKey)locationArray;
            for (Location loc : (Location[])this.getExpr().getArray(event)) {
                World world = loc.getWorld();
                if (world == null) continue;
                try {
                    UNSAFE.setBiomeKey((RegionAccessor)world, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), key);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }

    @NotNull
    protected String getPropertyName() {
        return "biome key";
    }

    @NotNull
    public Class<? extends NamespacedKey> getReturnType() {
        return NamespacedKey.class;
    }

    static {
        if (Skript.methodExists(UnsafeValues.class, (String)"getBiomeKey", (Class[])new Class[]{RegionAccessor.class, Integer.TYPE, Integer.TYPE, Integer.TYPE})) {
            ExprBiomeKeyLocation.register(ExprBiomeKeyLocation.class, NamespacedKey.class, (String)"biome key[s]", (String)"locations");
        }
    }
}

