/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import org.bukkit.block.Beacon;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.jetbrains.annotations.Nullable;

@Name(value="Beacon - Tier")
@Description(value={"Returns the current tier of a beacon block."})
@Examples(value={"on right click on a beacon:", "\tsend \"The current tier of this block is %beacon tier of event-block%\""})
@Since(value={"2.16.0"})
public class ExprBeaconTier
extends SimplePropertyExpression<Block, Integer> {
    @Nullable
    public Integer convert(Block block) {
        BlockState blockState = block.getState();
        if (blockState instanceof Beacon) {
            Beacon beacon = (Beacon)blockState;
            return beacon.getTier();
        }
        return null;
    }

    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    protected String getPropertyName() {
        return "beacon tier";
    }

    static {
        ExprBeaconTier.register(ExprBeaconTier.class, Integer.class, (String)"beacon tier", (String)"blocks");
    }
}

