/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.block.Beacon;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Beacon - Effect Range")
@Description(value={"Gets the effect range of a beacon.", "A negative range value means the beacon is using its default range based on tier."})
@Examples(value={"send effect range of event-block", "add 100 to beacon effect range of event-block", "loop 11 times:", "\tremove 10 from beacon effect range of event-block", "reset effect range of event-block"})
@Since(value={"2.16.0"})
public class ExprBeaconEffectRange
extends SimplePropertyExpression<Block, Number> {
    private static final boolean SUPPORTS_EFFECT_RANGE = Skript.methodExists(Beacon.class, (String)"getEffectRange", (Class[])new Class[0]);

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!SUPPORTS_EFFECT_RANGE) {
            Skript.error((String)"The 'effect range' expression can only be used on a PaperMC server!");
            return false;
        }
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Nullable
    public Number convert(Block block) {
        BlockState blockState = block.getState();
        if (blockState instanceof Beacon) {
            Beacon beacon = (Beacon)blockState;
            return beacon.getEffectRange();
        }
        return null;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            case Changer.ChangeMode.SET, Changer.ChangeMode.REMOVE, Changer.ChangeMode.ADD -> (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
            case Changer.ChangeMode.RESET -> (Class[])CollectionUtils.array((Object[])new Class[0]);
            default -> null;
        };
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        for (Block block : (Block[])this.getExpr().getArray(event)) {
            BlockState blockState = block.getState();
            if (!(blockState instanceof Beacon)) continue;
            Beacon beacon = (Beacon)blockState;
            if (delta == null) {
                beacon.resetEffectRange();
                beacon.update();
                continue;
            }
            double effectRange = beacon.getEffectRange();
            double newEffectRange = ((Number)delta[0]).doubleValue();
            switch (mode) {
                case SET: {
                    effectRange = newEffectRange;
                    break;
                }
                case ADD: {
                    effectRange += newEffectRange;
                    break;
                }
                case REMOVE: {
                    effectRange -= newEffectRange;
                }
            }
            beacon.setEffectRange(effectRange);
            beacon.update();
        }
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    protected String getPropertyName() {
        return "effect range";
    }

    static {
        ExprBeaconEffectRange.register(ExprBeaconEffectRange.class, Number.class, (String)"[beacon] effect range", (String)"blocks");
    }
}

