/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.block.Beacon;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.event.Event;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.Nullable;

@Name(value="Beacon - Primary/Secondary Effect")
@Description(value={"The primary/secondary potion effect of a beacon.", "\nNote:", "\nWhen getting the primary/secondary potion effect it will return as a Potion Effect and not a Potion Effect Type.", "\nIf you update the beacon inventory by opening it and placing an item you will lose any custom effects not normally applicable."})
@Examples(value={"on right click on a beacon with a diamond:", "\tbroadcast \"Primary: %primary beacon effect of clicked block%\"", "\tbroadcast \"Secondary: %secondary beacon effect of clicked block%\"", "\tset primary beacon effect of clicked block to strength", "\tclear secondary beacon potion effect"})
@Since(value={"2.16.0"})
public class ExprBeaconEffect
extends SimplePropertyExpression<Block, PotionEffect> {
    private boolean useSecondary;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.useSecondary = parseResult.hasTag("secondary");
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Nullable
    public PotionEffect convert(Block block) {
        BlockState blockState = block.getState();
        if (blockState instanceof Beacon) {
            Beacon beacon = (Beacon)blockState;
            return this.useSecondary ? beacon.getSecondaryEffect() : beacon.getPrimaryEffect();
        }
        return null;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            case Changer.ChangeMode.SET -> (Class[])CollectionUtils.array((Object[])new Class[]{PotionEffectType.class});
            case Changer.ChangeMode.DELETE -> (Class[])CollectionUtils.array((Object[])new Class[0]);
            default -> null;
        };
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        PotionEffectType potionEffectType = delta != null ? (PotionEffectType)delta[0] : null;
        for (Block block : (Block[])this.getExpr().getArray(event)) {
            BlockState blockState = block.getState();
            if (!(blockState instanceof Beacon)) continue;
            Beacon beacon = (Beacon)blockState;
            if (this.useSecondary) {
                beacon.setSecondaryEffect(potionEffectType);
            } else {
                beacon.setPrimaryEffect(potionEffectType);
            }
            beacon.update();
        }
    }

    public Class<? extends PotionEffect> getReturnType() {
        return PotionEffect.class;
    }

    protected String getPropertyName() {
        return (this.useSecondary ? "secondary" : "primary") + " beacon effect";
    }

    static {
        ExprBeaconEffect.register(ExprBeaconEffect.class, PotionEffect.class, (String)"(primary|:secondary) beacon [potion] effect", (String)"blocks");
    }
}

