/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.shanebeestudios.skbee.api.util.ItemUtils;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Attribute Modifier Properties")
@Description(value={"Represents the different components of an attribute modifier.", "NOTE: These cannot be changed.", "`id` = The unique NamespacedKey of a modifier (Requires Minecraft 1.21+).", "`name` = The name used to identify this modifier (For Minecraft 1.20.6 and below).", "`uuid` = The uuid used to identify this modifier (For Minecraft 1.20.6 and below).", "`amount` = Amount of change from the modifier.", "`slot` = Equipment Slot Group the item must be in for the modifier to take effect (Minecraft 1.20.6+ uses Equipment Slot Group, other versions use Equipment Slot).", "`operation` = The operation of a modifier. See [**McWiki**](https://minecraft.wiki/w/Attribute#Operations) for more details."})
@Examples(value={"set {_id} to modifier id of {_modifier}", "set {_slot} to modifier slot of {_modifier}", "if modifier amount of {_mod} > 1:"})
@Since(value={"3.5.9"})
public class ExprAttributeModifierProperties
extends SimplePropertyExpression<AttributeModifier, Object> {
    private int pattern;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.pattern = parseResult.mark;
        if (this.pattern == 0 && !ItemUtils.HAS_KEY) {
            Skript.error((String)"'modifier id' requires Minecraft 1.21+");
            return false;
        }
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Nullable
    public Object convert(AttributeModifier modifier) {
        return switch (this.pattern) {
            case 1 -> modifier.getName();
            case 2 -> modifier.getUniqueId().toString();
            case 3 -> modifier.getAmount();
            case 4 -> {
                if (ItemUtils.HAS_EQUIPMENT_SLOT_GROUP) {
                    yield modifier.getSlotGroup();
                }
                yield modifier.getSlot();
            }
            case 5 -> modifier.getOperation();
            default -> ItemUtils.HAS_KEY ? modifier.getKey() : null;
        };
    }

    @NotNull
    protected String getPropertyName() {
        return "modifier" + (switch (this.pattern) {
            case 1 -> "name";
            case 2 -> "uuid";
            case 3 -> "amount";
            case 4 -> "slot";
            case 5 -> "operation";
            default -> "id";
        });
    }

    @NotNull
    public Class<?> getReturnType() {
        return switch (this.pattern) {
            case 1, 2 -> String.class;
            case 3 -> Number.class;
            case 4 -> {
                if (ItemUtils.HAS_EQUIPMENT_SLOT_GROUP) {
                    yield EquipmentSlotGroup.class;
                }
                yield EquipmentSlot.class;
            }
            case 5 -> AttributeModifier.Operation.class;
            default -> NamespacedKey.class;
        };
    }

    static {
        ExprAttributeModifierProperties.register(ExprAttributeModifierProperties.class, Object.class, (String)"[attribute] modifier (0:id|1:name|2:uuid|3:amount|4:slot|5:operation)", (String)"attributemodifiers");
    }
}

