/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import com.shanebeestudios.skbee.elements.other.type.Types;
import org.bukkit.event.Event;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.trim.ArmorTrim;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="ArmorTrim - Item")
@Description(value={"Represents the armor trim of an item. You can get, set, add or delete/reset.", "Requires Minecraft 1.19.4+"})
@Examples(value={"add armor trim from gold_material and eye_pattern to armor trim of player's leggings", "set armor trim of player's helmet to armor trim from gold_material and eye_pattern", "delete armor trim of player's leggings", "reset armor trim of player's boots"})
@Since(value={"2.13.0"})
public class ExprArmorTrimItem
extends SimplePropertyExpression<ItemType, ArmorTrim> {
    @Nullable
    public ArmorTrim convert(ItemType itemType) {
        ItemMeta itemMeta = itemType.getItemMeta();
        if (itemMeta instanceof ArmorMeta) {
            ArmorMeta armorMeta = (ArmorMeta)itemMeta;
            return armorMeta.getTrim();
        }
        return null;
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[0]);
        }
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.ADD) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{ArmorTrim.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        Object object;
        ArmorTrim trim = null;
        if (delta != null && (object = delta[0]) instanceof ArmorTrim) {
            ArmorTrim armorTrim;
            trim = armorTrim = (ArmorTrim)object;
        }
        for (ItemType itemType : (ItemType[])this.getExpr().getArray(event)) {
            ItemMeta itemMeta = itemType.getItemMeta();
            if (!(itemMeta instanceof ArmorMeta)) continue;
            ArmorMeta armorMeta = (ArmorMeta)itemMeta;
            armorMeta.setTrim(trim);
            itemType.setItemMeta((ItemMeta)armorMeta);
        }
    }

    @NotNull
    public Class<? extends ArmorTrim> getReturnType() {
        return ArmorTrim.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "armor trim";
    }

    static {
        if (Types.HAS_ARMOR_TRIM) {
            ExprArmorTrimItem.register(ExprArmorTrimItem.class, ArmorTrim.class, (String)"armor trim", (String)"itemtypes");
        }
    }
}

