/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Absorption Amount")
@Description(value={"Represents the absorption amount of an entity."})
@Examples(value={"set {_absorption} to absorption amount of player", "set absorption amount of player to 5", "add 2 to absorption amount of player", "remove 2 from absorption amount of player", "reset absorption amount of player"})
@Since(value={"1.17.0"})
public class ExprAbsorptionAmount
extends SimplePropertyExpression<Entity, Number> {
    @Nullable
    public Number convert(Entity entity) {
        if (entity instanceof Damageable) {
            Damageable damageable = (Damageable)entity;
            return damageable.getAbsorptionAmount();
        }
        return null;
    }

    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            case Changer.ChangeMode.SET, Changer.ChangeMode.ADD, Changer.ChangeMode.REMOVE, Changer.ChangeMode.RESET -> (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
            default -> null;
        };
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        double value = delta != null && delta[0] != null ? ((Number)delta[0]).doubleValue() : 0.0;
        for (Entity entity : (Entity[])this.getExpr().getArray(event)) {
            if (!(entity instanceof Damageable)) continue;
            Damageable damageable = (Damageable)entity;
            double oldAmount = damageable.getAbsorptionAmount();
            double change = switch (mode) {
                case Changer.ChangeMode.SET -> value;
                case Changer.ChangeMode.ADD -> oldAmount + value;
                case Changer.ChangeMode.REMOVE -> oldAmount - value;
                default -> 0.0;
            };
            damageable.setAbsorptionAmount(Math.max(0.0, change));
        }
    }

    @NotNull
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @NotNull
    protected String getPropertyName() {
        return "absorption amount";
    }

    static {
        ExprAbsorptionAmount.register(ExprAbsorptionAmount.class, Number.class, (String)"absorption amount", (String)"entities");
    }
}

