/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.events;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.lang.util.SimpleEvent;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.BlockStateBlock;
import ch.njol.skript.util.Getter;
import ch.njol.skript.util.Timespan;
import ch.njol.skript.util.slot.Slot;
import com.destroystokyo.paper.event.entity.EntityRemoveFromWorldEvent;
import com.shanebeestudios.skbee.api.event.EntityBlockInteractEvent;
import com.shanebeestudios.skbee.api.util.Util;
import java.util.Locale;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Spellcaster;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDamageAbortEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.MoistureChangeEvent;
import org.bukkit.event.command.UnknownCommandEvent;
import org.bukkit.event.entity.EntityAirChangeEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.EntitySpellCastEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.entity.EntityUnleashEvent;
import org.bukkit.event.entity.PlayerLeashEntityEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.SpawnerSpawnEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.event.player.PlayerSpawnChangeEvent;
import org.bukkit.event.player.PlayerUnleashEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OtherEvents
extends SimpleEvent {
    static {
        Skript.registerEvent((String)"Block Physical Interact Event", OtherEvents.class, EntityBlockInteractEvent.class, (String[])new String[]{"block (interact|trample)"}).description(new String[]{"Called when an entity physically interacts with a block, for example,", " entities trampling farmland and villagers opening doors."}).examples(new String[]{"on block trample:", "\tif type of event-block is farmland:", "\t\tcancel event"}).since("1.5.0");
        EventValues.registerEventValue(EntityBlockInteractEvent.class, Block.class, (Getter)new Getter<Block, EntityBlockInteractEvent>(){

            @Nullable
            public Block get(EntityBlockInteractEvent event) {
                return event.getBlock();
            }
        }, (int)0);
        Skript.registerEvent((String)"Anvil Prepare Event", OtherEvents.class, PrepareAnvilEvent.class, (String[])new String[]{"[skbee] anvil prepare"}).description(new String[]{"Called when a player attempts to combine 2 items in an anvil.", "'event-slot' represents the result slot, can be used to get or set."}).examples(new String[]{"on anvil prepare:", "\tif slot 0 of event-inventory is a diamond sword:", "\t\tif slot 1 of event-inventory is an enchanted book:", "\t\t\tif stored enchants of slot 1 of event-inventory contains sharpness 5:", "\t\t\t\tset {_i} to slot 0 of event-inventory", "\t\t\t\tadd \"&aOOOOOOO\" and \"&bAHHHHHH\" to lore of {_i}", "\t\t\t\tenchant {_i} with sharpness 6", "\t\t\t\tset event-slot to {_i}", "\t\t\t\tset repair cost of event-inventory to 30"}).since("1.11.0");
        EventValues.registerEventValue(PrepareAnvilEvent.class, Slot.class, (Getter)new Getter<Slot, PrepareAnvilEvent>(){

            public Slot get(final PrepareAnvilEvent event) {
                return new Slot(){
                    final ItemStack result;
                    {
                        this.result = event.getResult();
                    }

                    @Nullable
                    public ItemStack getItem() {
                        return this.result;
                    }

                    public void setItem(@Nullable ItemStack item) {
                        event.setResult(item);
                    }

                    public int getAmount() {
                        if (this.result != null) {
                            return this.result.getAmount();
                        }
                        return 0;
                    }

                    public void setAmount(int amount) {
                        if (this.result != null) {
                            this.result.setAmount(amount);
                        }
                    }

                    public boolean isSameSlot(@NotNull Slot o) {
                        ItemStack item = o.getItem();
                        return item != null && item.isSimilar(this.result);
                    }

                    @NotNull
                    public String toString(@Nullable Event e, boolean debug) {
                        return "anvil inventory result slot";
                    }
                };
            }
        }, (int)0);
        if (Util.IS_RUNNING_MC_1_21) {
            EventValues.registerEventValue(PrepareAnvilEvent.class, Player.class, (Getter)new Getter<Player, PrepareAnvilEvent>(){

                public Player get(PrepareAnvilEvent event) {
                    return (Player)event.getView().getPlayer();
                }
            }, (int)0);
        }
        Skript.registerEvent((String)"Shear Entity", OtherEvents.class, PlayerShearEntityEvent.class, (String[])new String[]{"[player] shear entity"}).description(new String[]{"Called when a player shears an entity. Requires Minecraft 1.9.4+"}).examples(new String[]{"on player shear entity:"}).since("1.8.0");
        Skript.registerEvent((String)"Entity Change Block", OtherEvents.class, EntityChangeBlockEvent.class, (String[])new String[]{"entity change block"}).description(new String[]{"Called when any Entity changes a block and a more specific event is not available.", "Skript does partially have this event, but this version of it opens up ALL possibilities with this event.", "\nevent-entity = the entity which changed the block", "\nevent-block = the block that changed", "\nevent-blockdata = the blockdata the block has changed into"}).examples(new String[]{"on entity change block:", "\tif event-entity is a villager:", "\t\tif event-block is a composter:", "\t\t\theal event-entity"}).since("2.5.3");
        EventValues.registerEventValue(EntityChangeBlockEvent.class, BlockData.class, (Getter)new Getter<BlockData, EntityChangeBlockEvent>(){

            @NotNull
            public BlockData get(EntityChangeBlockEvent event) {
                return event.getBlockData();
            }
        }, (int)0);
        if (Skript.classExists((String)"org.bukkit.event.block.BlockDamageAbortEvent")) {
            Skript.registerEvent((String)"Block Damage Abort", OtherEvents.class, BlockDamageAbortEvent.class, (String[])new String[]{"block damage abort"}).description(new String[]{"Called when a player stops damaging a Block. Requires MC 1.18.x+"}).examples(new String[]{"on block damage abort:", "\tsend \"get back to work\""}).since("2.8.3");
            EventValues.registerEventValue(BlockDamageAbortEvent.class, Player.class, (Getter)new Getter<Player, BlockDamageAbortEvent>(){

                public Player get(BlockDamageAbortEvent event) {
                    return event.getPlayer();
                }
            }, (int)0);
        }
        Skript.registerEvent((String)"Entity Air Change", OtherEvents.class, EntityAirChangeEvent.class, (String[])new String[]{"[entity] air change"}).description(new String[]{"Called when the amount of air an entity has remaining changes.", "\n`event-number` = The amount of air the entity will have left (measured in ticks).", "\n`event-timespan` = The amount of air the entity will have left (as a time span).", "\n`past event-number` = The amount of air the entity had left before the event (measured in ticks).", "\n`past event-timespan` = The amount of air the entity had left before the event (as a time span)."}).examples(new String[]{"on entity air change:", "\tif event-entity is a player:", "\t\tcancel event"}).since("2.8.4");
        EventValues.registerEventValue(EntityAirChangeEvent.class, Number.class, (Getter)new Getter<Number, EntityAirChangeEvent>(){

            public Number get(EntityAirChangeEvent event) {
                Entity entity = event.getEntity();
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    return livingEntity.getRemainingAir();
                }
                return 0;
            }
        }, (int)-1);
        EventValues.registerEventValue(EntityAirChangeEvent.class, Timespan.class, (Getter)new Getter<Timespan, EntityAirChangeEvent>(){

            public Timespan get(EntityAirChangeEvent event) {
                int ticks = 0;
                Entity entity = event.getEntity();
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    ticks = livingEntity.getRemainingAir();
                }
                return Timespan.fromTicks((long)ticks);
            }
        }, (int)-1);
        EventValues.registerEventValue(EntityAirChangeEvent.class, Number.class, (Getter)new Getter<Number, EntityAirChangeEvent>(){

            public Number get(EntityAirChangeEvent event) {
                return event.getAmount();
            }
        }, (int)0);
        EventValues.registerEventValue(EntityAirChangeEvent.class, Timespan.class, (Getter)new Getter<Timespan, EntityAirChangeEvent>(){

            public Timespan get(EntityAirChangeEvent event) {
                return Timespan.fromTicks((long)event.getAmount());
            }
        }, (int)0);
        EventValues.registerEventValue(SpawnerSpawnEvent.class, Block.class, (Getter)new Getter<Block, SpawnerSpawnEvent>(){

            @Nullable
            public Block get(SpawnerSpawnEvent event) {
                CreatureSpawner spawner = event.getSpawner();
                if (spawner == null) {
                    return null;
                }
                return spawner.getBlock();
            }
        }, (int)0);
        EventValues.registerEventValue(PlayerInteractEvent.class, BlockFace.class, (Getter)new Getter<BlockFace, PlayerInteractEvent>(){

            public BlockFace get(PlayerInteractEvent event) {
                return event.getBlockFace();
            }
        }, (int)0);
        EventValues.registerEventValue(ProjectileHitEvent.class, BlockFace.class, (Getter)new Getter<BlockFace, ProjectileHitEvent>(){

            @Nullable
            public BlockFace get(ProjectileHitEvent event) {
                return event.getHitBlockFace();
            }
        }, (int)0);
        EventValues.registerEventValue(BlockPlaceEvent.class, BlockFace.class, (Getter)new Getter<BlockFace, BlockPlaceEvent>(){

            @Nullable
            public BlockFace get(BlockPlaceEvent event) {
                Block placed = event.getBlockPlaced();
                Block against = event.getBlockAgainst();
                return against.getFace(placed);
            }
        }, (int)0);
        Skript.registerEvent((String)"Spell Cast", OtherEvents.class, EntitySpellCastEvent.class, (String[])new String[]{"[entity] spell cast"}).description(new String[]{"Called when a Spellcaster casts a spell."}).examples(new String[]{"on spell cast:", "\tif event-entity is an evoker:", "\t\tif event-spell is fangs:", "\t\t\tcancel event"}).since("2.14.0");
        EventValues.registerEventValue(EntitySpellCastEvent.class, Spellcaster.Spell.class, (Getter)new Getter<Spellcaster.Spell, EntitySpellCastEvent>(){

            public Spellcaster.Spell get(EntitySpellCastEvent event) {
                return event.getSpell();
            }
        }, (int)0);
        Skript.registerEvent((String)"Entity Shoot Bow", OtherEvents.class, EntityShootBowEvent.class, (String[])new String[]{"entity shoot bow"}).description(new String[]{"Called when a LivingEntity shoots a bow/crossbow firing an arrow.", "`event-entity` = Entity which shot the bow.", "`event-projectile` = The projectile which was shot.", "`event-item[type]` = The item which will be consumed from the entity's inventory (if any)."}).examples(new String[]{"on entity shoot bow:", "\tif name of shot bow != \"Mr Bow\":", "\t\tcancel event", "on entity shoot bow:", "\tif gamemode of player = survival:", "\t\tgive player 1 of event-item"}).since("2.16.0");
        EventValues.registerEventValue(EntityShootBowEvent.class, Projectile.class, (Getter)new Getter<Projectile, EntityShootBowEvent>(){

            @Nullable
            public Projectile get(EntityShootBowEvent event) {
                Entity entity = event.getProjectile();
                if (entity instanceof Projectile) {
                    Projectile projectile = (Projectile)entity;
                    return projectile;
                }
                return null;
            }
        }, (int)0);
        EventValues.registerEventValue(EntityShootBowEvent.class, ItemType.class, (Getter)new Getter<ItemType, EntityShootBowEvent>(){

            @Nullable
            public ItemType get(EntityShootBowEvent event) {
                ItemStack consumable = event.getConsumable();
                if (consumable != null) {
                    return new ItemType(consumable);
                }
                return null;
            }
        }, (int)0);
        EventValues.registerEventValue(EntityShootBowEvent.class, ItemStack.class, (Getter)new Getter<ItemStack, EntityShootBowEvent>(){

            @Nullable
            public ItemStack get(EntityShootBowEvent event) {
                return event.getConsumable();
            }
        }, (int)0);
        Skript.registerEvent((String)"Entity Teleport", OtherEvents.class, EntityTeleportEvent.class, (String[])new String[]{"entity teleport"}).description(new String[]{"Thrown when a non-player entity is teleported from one location to another.", "This may be as a result of natural causes (Enderman, Shulker), pathfinding (Wolf), or commands (/teleport).", "\n`past event-location` = Location teleported from.", "\n`event-location` = Location teleported to."}).examples(new String[]{"on entity teleport:", "\tif event-entity is an enderman:", "\t\tcancel event"}).since("2.18.0");
        EventValues.registerEventValue(EntityTeleportEvent.class, Location.class, (Getter)new Getter<Location, EntityTeleportEvent>(){

            public Location get(EntityTeleportEvent event) {
                return event.getFrom();
            }
        }, (int)-1);
        EventValues.registerEventValue(EntityTeleportEvent.class, Location.class, (Getter)new Getter<Location, EntityTeleportEvent>(){

            public Location get(EntityTeleportEvent event) {
                return event.getTo();
            }
        }, (int)0);
        Skript.registerEvent((String)"Moisture Change", OtherEvents.class, MoistureChangeEvent.class, (String[])new String[]{"moisture change"}).description(new String[]{"Called when the moisture level of a farmland block changes."}).examples(new String[]{"on moisture change:", "\tcancel event", "\tset event-block to farmland[moisture=7]"}).since("3.0.0");
        EventValues.registerEventValue(MoistureChangeEvent.class, Block.class, (Getter)new Getter<Block, MoistureChangeEvent>(){

            @NotNull
            public Block get(MoistureChangeEvent event) {
                return new BlockStateBlock(event.getNewState());
            }
        }, (int)1);
        Skript.registerEvent((String)"Block Explode", OtherEvents.class, BlockExplodeEvent.class, (String[])new String[]{"block explode"}).description(new String[]{"Called when a block explodes interacting with blocks.", "The event isn't called if the gamerule MOB_GRIEFING is disabled as no block interaction will occur.", "The Block returned by this event is not necessarily the block that caused the explosion,", "just the block at the location where the explosion originated.", "\n`past event-itemtype` will return the type of the block which exploded.", "\n`past event-blockdata` will return the blockdata of the block which exploded."}).examples(new String[]{""}).since("3.2.0");
        EventValues.registerEventValue(BlockExplodeEvent.class, BlockData.class, (Getter)new Getter<BlockData, BlockExplodeEvent>(){

            public BlockData get(BlockExplodeEvent event) {
                return event.getBlock().getBlockData();
            }
        }, (int)0);
        EventValues.registerEventValue(BlockExplodeEvent.class, BlockData.class, (Getter)new Getter<BlockData, BlockExplodeEvent>(){

            @NotNull
            public BlockData get(BlockExplodeEvent event) {
                BlockState explodedBlockState = event.getExplodedBlockState();
                return explodedBlockState.getBlockData();
            }
        }, (int)-1);
        EventValues.registerEventValue(BlockExplodeEvent.class, ItemType.class, (Getter)new Getter<ItemType, BlockExplodeEvent>(){

            public ItemType get(BlockExplodeEvent event) {
                return new ItemType(event.getBlock().getType());
            }
        }, (int)0);
        EventValues.registerEventValue(BlockExplodeEvent.class, ItemType.class, (Getter)new Getter<ItemType, BlockExplodeEvent>(){

            @NotNull
            public ItemType get(BlockExplodeEvent event) {
                BlockState explodedBlockState = event.getExplodedBlockState();
                return new ItemType(explodedBlockState.getType());
            }
        }, (int)-1);
        Skript.registerEvent((String)"Player Leash", OtherEvents.class, PlayerLeashEntityEvent.class, (String[])new String[]{"player leash entity"}).description(new String[]{"Called immediately prior to a creature being leashed by a player.", "\n`event-entity` = Entity which got leashed.", "\n`future event-entity` = The entity the leashed entity is leashed to (could be a player or leash hitch on a fence).", "\n`event-player` = Player whom leashed the entity."}).examples(new String[]{"on player leash entity:", "\tkill event-entity"}).since("3.2.0");
        EventValues.registerEventValue(PlayerLeashEntityEvent.class, Entity.class, (Getter)new Getter<Entity, PlayerLeashEntityEvent>(){

            public Entity get(PlayerLeashEntityEvent event) {
                return event.getEntity();
            }
        }, (int)0);
        EventValues.registerEventValue(PlayerLeashEntityEvent.class, Entity.class, (Getter)new Getter<Entity, PlayerLeashEntityEvent>(){

            public Entity get(PlayerLeashEntityEvent event) {
                return event.getLeashHolder();
            }
        }, (int)1);
        EventValues.registerEventValue(PlayerLeashEntityEvent.class, Player.class, (Getter)new Getter<Player, PlayerLeashEntityEvent>(){

            public Player get(PlayerLeashEntityEvent event) {
                return event.getPlayer();
            }
        }, (int)0);
        Skript.registerEvent((String)"Entity Unleash", OtherEvents.class, EntityUnleashEvent.class, (String[])new String[]{"entity unleash"}).description(new String[]{"Called immediately prior to an entity being unleashed.", "Cancelling this event when either the leashed entity dies, the entity changes dimension, or", "the client has disconnected the leash will have no effect.", "\n`event-string` = The reason for unleashing.", "Options are \"distance\" (When the entity's leashholder is more than 10 blocks away),", "\"holder_gone\" (When the entity's leashholder has died or logged out, and so is unleashed),", "\"player_unleash\" (When the entity's leashholder attempts to unleash it), \"unknown\""}).examples(new String[]{"on entity unleash:", "\tif event-entity is a cow:", "\t\tif event-string = \"distance\":", "\t\t\tcancel event"}).since("3.2.0");
        EventValues.registerEventValue(EntityUnleashEvent.class, String.class, (Getter)new Getter<String, EntityUnleashEvent>(){

            public String get(EntityUnleashEvent event) {
                return event.getReason().name().toLowerCase(Locale.ROOT);
            }
        }, (int)0);
        EventValues.registerEventValue(EntityUnleashEvent.class, Player.class, (Getter)new Getter<Player, EntityUnleashEvent>(){

            @Nullable
            public Player get(EntityUnleashEvent event) {
                if (event instanceof PlayerUnleashEntityEvent) {
                    PlayerUnleashEntityEvent playerUnleashEntityEvent = (PlayerUnleashEntityEvent)event;
                    return playerUnleashEntityEvent.getPlayer();
                }
                return null;
            }
        }, (int)0);
        Class<EntityRemoveEvent> eventClass = null;
        boolean bukkitRemoveEvent = false;
        if (Skript.classExists((String)"org.bukkit.event.entity.EntityRemoveEvent")) {
            eventClass = EntityRemoveEvent.class;
            bukkitRemoveEvent = true;
        } else if (Skript.classExists((String)"com.destroystokyo.paper.event.entity.EntityRemoveFromWorldEvent")) {
            eventClass = EntityRemoveFromWorldEvent.class;
        }
        if (eventClass != null) {
            Skript.registerEvent((String)"Entity Remove from World", OtherEvents.class, eventClass, (String[])new String[]{"entity remove[d] [from world]"}).description(new String[]{"Fired any time an entity is being removed from a world for any reason.", "Requires a PaperMC server or Spigot 1.20.4+ server.", "`event-entityremovecause` = The reason the entity was removed (requires MC 1.20.4+)."}).examples(new String[]{"on entity removed from world:", "\tbroadcast \"a lonely %event-entity% left the world.\""}).since("2.7.2");
            if (bukkitRemoveEvent) {
                EventValues.registerEventValue(EntityRemoveEvent.class, EntityRemoveEvent.Cause.class, (Getter)new Getter<EntityRemoveEvent.Cause, EntityRemoveEvent>(){

                    public EntityRemoveEvent.Cause get(EntityRemoveEvent event) {
                        return event.getCause();
                    }
                }, (int)0);
            }
        }
        if (Skript.classExists((String)"org.bukkit.event.player.PlayerSpawnChangeEvent")) {
            Skript.registerEvent((String)"Player Spawn Change", OtherEvents.class, PlayerSpawnChangeEvent.class, (String[])new String[]{"player spawn change"}).description(new String[]{"This event is fired when the spawn point of the player is changed."}).examples(new String[]{"on player spawn change:", "\tif event-playerspawnchangereason = bed or respawn_anchor:", "\t\tcancel event", "\t\tsend \"Nope... sorry!\""}).since("3.4.0");
            EventValues.registerEventValue(PlayerSpawnChangeEvent.class, PlayerSpawnChangeEvent.Cause.class, (Getter)new Getter<PlayerSpawnChangeEvent.Cause, PlayerSpawnChangeEvent>(){

                public PlayerSpawnChangeEvent.Cause get(PlayerSpawnChangeEvent event) {
                    return event.getCause();
                }
            }, (int)0);
            EventValues.registerEventValue(PlayerSpawnChangeEvent.class, Location.class, (Getter)new Getter<Location, PlayerSpawnChangeEvent>(){

                @Nullable
                public Location get(PlayerSpawnChangeEvent event) {
                    return event.getPlayer().getBedSpawnLocation();
                }
            }, (int)0);
            EventValues.registerEventValue(PlayerSpawnChangeEvent.class, Location.class, (Getter)new Getter<Location, PlayerSpawnChangeEvent>(){

                @Nullable
                public Location get(PlayerSpawnChangeEvent event) {
                    return event.getNewSpawn();
                }
            }, (int)1);
        }
        if (Skript.classExists((String)"org.bukkit.event.command.UnknownCommandEvent")) {
            Skript.registerEvent((String)"Unknown Command", OtherEvents.class, UnknownCommandEvent.class, (String[])new String[]{"unknown command"}).description(new String[]{"This event is fired when a player executes a command that is not defined.", "`event-string` = The command that was sent.", "`event-sender/player` = Who sent the command."}).examples(new String[]{""}).since("3.10.0");
            EventValues.registerEventValue(UnknownCommandEvent.class, String.class, UnknownCommandEvent::getCommandLine);
            EventValues.registerEventValue(UnknownCommandEvent.class, CommandSender.class, UnknownCommandEvent::getSender);
        }
    }
}

