/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.events;

import ch.njol.skript.Skript;
import ch.njol.skript.bukkitutil.EntityUtils;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.EventValues;
import com.destroystokyo.paper.event.entity.PhantomPreSpawnEvent;
import com.destroystokyo.paper.event.entity.PreCreatureSpawnEvent;
import com.destroystokyo.paper.event.entity.PreSpawnerSpawnEvent;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EvtPreSpawn
extends SkriptEvent {
    private static final boolean HAS_PRE_CREATURE_SPAWN_EVENT = Skript.classExists((String)"com.destroystokyo.paper.event.entity.PreCreatureSpawnEvent");
    private static final boolean HAS_PRE_SPAWNER_SPAWN_EVENT = Skript.classExists((String)"com.destroystokyo.paper.event.entity.PreSpawnerSpawnEvent");
    private static final boolean HAS_PRE_PHANTOM_SPAWN_EVENT = Skript.classExists((String)"com.destroystokyo.paper.event.entity.PhantomPreSpawnEvent");
    private Literal<EntityData<?>> spawnedEntities;

    public boolean init(Literal<?>[] literals, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.spawnedEntities = literals[0];
        return true;
    }

    public boolean check(Event event) {
        if (this.spawnedEntities == null) {
            return true;
        }
        if (event instanceof PreCreatureSpawnEvent) {
            PreCreatureSpawnEvent preCreatureSpawnEvent = (PreCreatureSpawnEvent)event;
            EntityData spawnedEntity = EntityUtils.toSkriptEntityData((EntityType)preCreatureSpawnEvent.getType());
            return this.spawnedEntities.check(event, entityData -> entityData.isSupertypeOf(spawnedEntity));
        }
        return false;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "pre spawn" + (String)(this.spawnedEntities != null ? " of " + this.spawnedEntities.toString(e, d) : "");
    }

    static {
        if (HAS_PRE_CREATURE_SPAWN_EVENT) {
            Skript.registerEvent((String)"Pre Creature Spawn", EvtPreSpawn.class, PreCreatureSpawnEvent.class, (String[])new String[]{"pre [creature] spawn[ing] [of %entitydatas%]"}).description(new String[]{"Called before an entity is spawned into the world. Requires a PaperMC server.", "\nNote: The spawning entity does not exist when this event is called only the entitytype exists.", "This event is called very frequently, and can cause server lag, use it sparingly.", "\n`event-spawnreason` = the reason the entity is spawned.", "\n`event-location` = the location the spawned entity will appear.", "\n`event-entitytype` = the type of entity being spawned."}).examples(new String[]{"on pre spawn of a pig:", "\tbroadcast \"a %event-entitytype% is spawning in\""}).since("2.16.0");
            EventValues.registerEventValue(PreCreatureSpawnEvent.class, Location.class, PreCreatureSpawnEvent::getSpawnLocation, (int)0);
            EventValues.registerEventValue(PreCreatureSpawnEvent.class, EntityData.class, event -> EntityUtils.toSkriptEntityData((EntityType)event.getType()), (int)0);
            EventValues.registerEventValue(PreCreatureSpawnEvent.class, CreatureSpawnEvent.SpawnReason.class, PreCreatureSpawnEvent::getReason, (int)0);
        }
        if (HAS_PRE_SPAWNER_SPAWN_EVENT) {
            Skript.registerEvent((String)"Pre Spawner Spawn", EvtPreSpawn.class, PreSpawnerSpawnEvent.class, (String[])new String[]{"pre spawner spawn[ing] [of %entitydatas%]"}).description(new String[]{"Called before an entity is spawned via a spawner. Requires a PaperMC server.", "\nNote: The spawned entity does not exist when this event is called only the entitytype exists.", "\nView the pre creature spawn event for more event values.", "\n`event-block` = the block location of the spawner spawning the entity."}).examples(new String[]{"on pre spawner spawn of a zombie:", "\tbroadcast \"%event-entitytype% is spawning in\""}).since("2.16.0");
            EventValues.registerEventValue(PreSpawnerSpawnEvent.class, Block.class, event -> event.getSpawnerLocation().getBlock(), (int)0);
        }
        if (HAS_PRE_PHANTOM_SPAWN_EVENT) {
            Skript.registerEvent((String)"Pre Phantom Spawn", EvtPreSpawn.class, PhantomPreSpawnEvent.class, (String[])new String[]{"pre phantom spawn[ing]"}).description(new String[]{"Called before a phantom is spawned for an entity. Requires a PaperMC server.", "\nNote: The phantom entity does not exist when this event is called only the entitytype exists.", "\nView the pre creature spawn event for more event values.", "\n`event-entity` = the entity the spawned phantom is spawning for."}).examples(new String[]{"on pre phantom spawn:", "\tbroadcast \"Watch out %event-entity% a phantom is coming!\""}).since("2.16.0");
            EventValues.registerEventValue(PhantomPreSpawnEvent.class, Entity.class, event -> event.getSpawningEntity(), (int)0);
        }
    }
}

