/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.events;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.EventValues;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EvtPotionEffect
extends SkriptEvent {
    private static final EntityPotionEffectEvent.Action[] ACTIONS;
    private int eventAction;

    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.eventAction = matchedPattern;
        return true;
    }

    public boolean check(Event event) {
        if (event instanceof EntityPotionEffectEvent) {
            EntityPotionEffectEvent potionEvent = (EntityPotionEffectEvent)event;
            return potionEvent.getAction() == ACTIONS[this.eventAction];
        }
        return false;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "entity potion effect " + String.valueOf(ACTIONS[this.eventAction]);
    }

    static {
        Skript.registerEvent((String)"Entity Potion Effect", EvtPotionEffect.class, EntityPotionEffectEvent.class, (String[])new String[]{"[entity] potion effect added", "[entity] potion effect changed", "[entity] potion effect cleared", "[entity] potion effect removed"}).description(new String[]{"Called when a potion effect is modified on an entity.", "ADDED = When the potion effect is added because the entity didn't have it's type.", "CHANGED = When the entity already had the potion effect type, but the effect is changed.", "CLEARED = When the effect is removed due to all effects being removed.", "REMOVED = When the potion effect type is completely removed.", "event-potioneffect = new effect.", "past event-potioneffect = old effect.", "event-potioneffecttype = type of potion effect."}).examples(new String[]{"on potion effect added:", "\tif event-potioneffecttype = night vision:", "\t\tcancel event", "\t\tsend \"NO NIGHT VISION FOR YOU!!!\"", "", "on potion effect added:", "\tif event-potioneffectcause = totem_effect:", "\t\tteleport player to {spawn}", "", "on potion effect changed:", "\tremove event-potioneffecttype from player", "\t", "on potion effect cleared:", "\tif event-entity is a player:", "\t\tbroadcast \"ALL EFFECTS CLEARED FOR: %event-entity%\"", "", "on potion effect removed:", "\tif event-potioneffecttype = night vision:", "\t\tkill event-entity"}).since("1.17.0");
        EventValues.registerEventValue(EntityPotionEffectEvent.class, PotionEffect.class, EntityPotionEffectEvent::getOldEffect, (int)-1);
        EventValues.registerEventValue(EntityPotionEffectEvent.class, PotionEffect.class, EntityPotionEffectEvent::getNewEffect, (int)0);
        EventValues.registerEventValue(EntityPotionEffectEvent.class, PotionEffectType.class, EntityPotionEffectEvent::getModifiedType, (int)0);
        EventValues.registerEventValue(EntityPotionEffectEvent.class, EntityPotionEffectEvent.Cause.class, EntityPotionEffectEvent::getCause, (int)0);
        ACTIONS = new EntityPotionEffectEvent.Action[]{EntityPotionEffectEvent.Action.ADDED, EntityPotionEffectEvent.Action.CHANGED, EntityPotionEffectEvent.Action.CLEARED, EntityPotionEffectEvent.Action.REMOVED};
    }
}

