/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.StringUtils;
import com.shanebeestudios.skbee.api.skript.base.Effect;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Name(value="Resource Pack Send")
@Description(value={"Send a resource pack to a player with a UUID, optional hash, optional prompt message, and the option to force it.", "The uuid is used to later remove the pack from the player if need be. Requires Minecraft 1.20.4+"})
@Examples(value={"set {pack::1} to random uuid", "send resource pack from url \"some.url\" with uuid {pack::1} to all players", "send resource pack from url \"some.url\" with uuid {pack::1} to all players with force", "send resource pack from url \"some.url\" with uuid {pack::1} with prompt \"This Adds Cool Stuff!!!\" to player with force"})
@Since(value={"3.4.0"})
public class EffResourcePackSend
extends Effect {
    private Expression<String> url;
    private Expression<String> uuid;
    private Expression<String> hash;
    private Expression<String> prompt;
    private Expression<Player> players;
    private boolean force;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.url = exprs[0];
        this.uuid = exprs[1];
        this.hash = exprs[2];
        this.prompt = exprs[3];
        this.players = exprs[4];
        this.force = parseResult.hasTag("force");
        return true;
    }

    protected void execute(Event event) {
        UUID uuid;
        String prompt;
        String url = (String)this.url.getSingle(event);
        String hash = this.hash != null ? (String)this.hash.getSingle(event) : null;
        String uuidString = (String)this.uuid.getSingle(event);
        String string = prompt = this.prompt != null ? (String)this.prompt.getSingle(event) : null;
        if (url == null || uuidString == null) {
            return;
        }
        try {
            uuid = UUID.fromString(uuidString);
        }
        catch (IllegalArgumentException ex) {
            this.error("Invalid UUID '" + uuidString + "' // " + ex.getMessage());
            return;
        }
        byte[] hashBytes = hash != null ? StringUtils.hexStringToByteArray((String)hash) : null;
        for (Player player : (Player[])this.players.getArray(event)) {
            player.addResourcePack(uuid, url, hashBytes, prompt, this.force);
        }
    }

    @NotNull
    public String toString(Event e, boolean d) {
        String url = this.url.toString(e, d);
        String hash = this.hash != null ? " with hash " + this.hash.toString(e, d) : "";
        String players = this.players.toString(e, d);
        String uuid = this.uuid.toString(e, d);
        String prompt = this.prompt != null ? " with prompt " + this.prompt.toString(e, d) : "";
        String force = this.force ? " with force" : "";
        return String.format("send resource pack from url %s with uuid %s %s %s to %s %s", url, uuid, hash, prompt, players, force);
    }

    static {
        if (Skript.methodExists(Player.class, (String)"removeResourcePacks", (Class[])new Class[0])) {
            Skript.registerEffect(EffResourcePackSend.class, (String[])new String[]{"send [the] resource pack [from [[the] URL]] %string% with (uuid|id) %string% [with hash %-string%] [with prompt %-string%] to %players% [force:with force]"});
        }
    }
}

