/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.Location;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.InventoryView;
import org.jetbrains.annotations.NotNull;

@Name(value="Open Real Inventory")
@Description(value={"Open real inventories to players.", "This will open a real inventory object instead of a custom inventory object to players.", "Most of these (except enchanting and workbench) require a PaperMC server.", "`at %location%` is used to open an inventory at an actual block (Optional, will default to player's location).", "Some inventories require a location of a block for extra functionality,such as an enchanting table uses nearby bookshelves to determine enchantment level."})
@Examples(value={"open real anvil inventory to player", "open real anvil named \"Mr Anvil\" to player", "open real anvil at location(1,1,1) named \"Senor Anvil\" to player"})
@Since(value={"3.6.0"})
public class EffOpenRealInventory
extends Effect {
    private static final boolean HAS_PAPER = Skript.methodExists(HumanEntity.class, (String)"openAnvil", (Class[])new Class[]{Location.class, Boolean.TYPE});
    private InventoryViewType viewType;
    private Expression<Location> location;
    private Expression<String> name;
    private Expression<Player> players;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.viewType = InventoryViewType.values()[matchedPattern];
        if (!this.viewType.canUse) {
            Skript.error((String)("'open real " + this.viewType.name + "' requires PaperMC."));
            return false;
        }
        this.location = exprs[0];
        this.name = exprs[1];
        this.players = exprs[2];
        return true;
    }

    protected void execute(Event event) {
        Location location = this.location != null ? (Location)this.location.getSingle(event) : null;
        String name = this.name != null ? (String)this.name.getSingle(event) : null;
        for (Player player : (Player[])this.players.getArray(event)) {
            InventoryView inventoryView;
            switch (this.viewType.ordinal()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case 0: {
                    InventoryView inventoryView2 = player.openAnvil(location, true);
                    break;
                }
                case 1: {
                    InventoryView inventoryView2 = player.openCartographyTable(location, true);
                    break;
                }
                case 2: {
                    InventoryView inventoryView2 = player.openEnchanting(location, true);
                    break;
                }
                case 3: {
                    InventoryView inventoryView2 = player.openGrindstone(location, true);
                    break;
                }
                case 4: {
                    InventoryView inventoryView2 = player.openLoom(location, true);
                    break;
                }
                case 5: {
                    InventoryView inventoryView2 = player.openSmithingTable(location, true);
                    break;
                }
                case 6: {
                    InventoryView inventoryView2 = player.openStonecutter(location, true);
                    break;
                }
                case 7: {
                    InventoryView inventoryView2 = inventoryView = player.openWorkbench(location, true);
                }
            }
            if (inventoryView == null || name == null) continue;
            inventoryView.setTitle(name);
        }
    }

    @NotNull
    public String toString(Event e, boolean d) {
        String loc = this.location != null ? "at " + this.location.toString(e, d) : "";
        String name = this.name != null ? "named " + this.name.toString(e, d) : "";
        return "open real " + this.viewType.name + " inventory " + loc + name + "to " + this.players.toString(e, d);
    }

    static {
        InventoryViewType[] viewTypes = InventoryViewType.values();
        int size = viewTypes.length;
        String[] patterns = new String[size];
        for (int i = 0; i < size; ++i) {
            patterns[i] = "open real " + viewTypes[i].name + " [inventory] [at %-location%] [named %-string%] to %players%";
        }
        Skript.registerEffect(EffOpenRealInventory.class, (String[])patterns);
    }

    static enum InventoryViewType {
        ANVIL("anvil", true),
        CARTOGRAPHY("cartography [table]", true),
        ENCHANTING("enchanting [table]", false),
        GRINDSTONE("grindstone", true),
        LOOM("loom", true),
        SMITHING("smithing [table]", true),
        STONECUTTER("stonecutter", true),
        WORKBENCH("workbench", false);

        private final String name;
        private final boolean canUse;

        private InventoryViewType(String name, boolean requiresPaper) {
            this.name = name;
            this.canUse = !requiresPaper || HAS_PAPER;
        }
    }
}

