/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Hurt Animation")
@Description(value={"Makes this living entity flash red as if they were damaged. Requires MC 1.20.1+", "\nNote: Yaw = The direction the damage is coming from in relation to the entity,", "where 0 is in front of the player, 90 is to the right, 180 is behind, and 270 is to the left"})
@Examples(value={"play hurt animation on player", "play hurt animation on all players", "play hurt animation on all players with yaw 270", "play hurt animation on all mobs"})
@Since(value={"2.15.0"})
public class EffHurtAnimation
extends Effect {
    private Expression<Entity> entities;
    private Expression<Number> yaw;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entities = exprs[0];
        this.yaw = exprs[1];
        return true;
    }

    protected void execute(Event event) {
        Number yawSingle;
        float yaw = 0.0f;
        if (this.yaw != null && (yawSingle = (Number)this.yaw.getSingle(event)) != null) {
            yaw = yawSingle.floatValue();
        }
        for (Entity entity : (Entity[])this.entities.getArray(event)) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.playHurtAnimation(yaw);
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        String yaw = this.yaw != null ? " with yaw " + this.yaw.toString(e, d) : "";
        return "player hurt animation on " + this.entities.toString(e, d) + yaw;
    }

    static {
        if (Skript.methodExists(LivingEntity.class, (String)"playHurtAnimation", (Class[])new Class[]{Float.TYPE})) {
            Skript.registerEffect(EffHurtAnimation.class, (String[])new String[]{"play hurt animation on %entities% [with yaw %-number%]"});
        }
    }
}

