/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.skbee.elements.other.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.EntityEffect;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Entity Effect")
@Description(value={"Play different EntityEffects on entities.", "\nNote: Some effects will only play on certain entities, ex: `wolf_shake` will only play on a wolf."})
@Examples(value={"play entity effect break_equipment_main_hand on player", "play entity effect death on all mobs"})
@Since(value={"3.0.0"})
public class EffEntityEffect
extends Effect {
    private Expression<EntityEffect> entityEffect;
    private Expression<Entity> entities;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entityEffect = exprs[0];
        this.entities = exprs[1];
        return true;
    }

    protected void execute(Event event) {
        EntityEffect entityEffect = (EntityEffect)this.entityEffect.getSingle(event);
        if (entityEffect == null) {
            return;
        }
        Class applicable = entityEffect.getApplicable();
        for (Entity entity : (Entity[])this.entities.getArray(event)) {
            if (!applicable.isAssignableFrom(entity.getClass())) continue;
            entity.playEffect(entityEffect);
        }
    }

    @NotNull
    public String toString(@Nullable Event e, boolean d) {
        return "play entity effect " + this.entityEffect.toString(e, d) + " on " + this.entities.toString(e, d);
    }

    static {
        Skript.registerEffect(EffEntityEffect.class, (String[])new String[]{"play entity effect %entityeffect% on %entities%"});
    }
}

